part of mine;

/// 用户信息
class BuildUser extends StatelessWidget {
  final void Function()? onTap;
  final UserInfoModel userInfo;

  const BuildUser({super.key, this.onTap, required this.userInfo});

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      behavior: HitTestBehavior.opaque,
      onTap: onTap,
      child: Container(
        margin: EdgeInsets.only(left: 10.w, right: 10.w),
        color: Colors.transparent,
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Row(
              children: [
                Container(
                  width: 50.w,
                  height: 50.w,
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(22.5.w),
                    color: Colors.cyan,
                  ),
                  // color: Colors.cyan,
                  child: CustomImage.network(
                    url: userInfo.headImg ?? '',
                    placeholder: Image.asset('assets/images/user_default_icon.png'),
                    radius: 22.5.w,
                  ),
                ),
                Gaps.hGaps10,
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        ConstrainedBox(
                          constraints: BoxConstraints(
                            maxWidth: 150.w, // 设置最大宽度
                          ),
                          child: Text(
                            userInfo.name ?? '',
                            maxLines: 1,
                            overflow: TextOverflow.ellipsis,
                            style: TextStyle(
                                color: Colours.c3,
                                fontSize: 15.w,
                                fontWeight: Fonts.medium,
                                height: 1.6.w),
                          ),
                        ),
                        Gaps.hGaps20,
                        Stack(
                          children: [
                            Container(
                              margin: EdgeInsets.only(top: 5.w),
                              padding: EdgeInsets.only(right: 8.w, left: 8.w),
                              height: 20.w,
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(21.w),
                                gradient: LinearGradient(
                                  colors: [
                                    AppTheme.primary.withOpacity(0.03),
                                    AppTheme.primary.withOpacity(0.1)
                                  ], // 不可点击时的颜色，透明度为0.7
                                  begin: Alignment.centerLeft,
                                  end: Alignment.centerRight,
                                ),
                              ),
                              child: Row(
                                children: [
                                  SizedBox(
                                    width: 16.w,
                                    height: 17.w,
                                  ),
                                  Text(
                                    userInfo.gradeName ?? '',
                                    style: TextStyle(
                                        fontSize: 11.w,
                                        color: AppTheme.primary),
                                  )
                                ],
                              ),
                            ),
                            Positioned(
                              top: 7.w,
                              left: 8.w,
                              child: SizedBox(
                                  width: 16.w,
                                  height: 17.w,
                                  child:
                                      Image.asset('assets/images/grade.png')),
                            )
                          ],
                        )
                      ],
                    ),
                    Gaps.vGaps5,
                    Text(
                      userInfo.phone ?? '',
                      style: TextStyle(fontSize: 12.w, color: Colours.c6),
                    )
                  ],
                ),
                Gaps.hGaps20,
              ],
            ),
            SizedBox(
              width: 7.w,
              height: 12.w,
              child: Image.asset('assets/images/right_arrow.png',fit: BoxFit.cover,),
            )
          ],
        ),
      ),
    );
  }
}
