part of user_notes_des;

class UserNotesDesPage extends StatefulWidget {
  final CourseModel model;
  const UserNotesDesPage({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  State<UserNotesDesPage> createState() => _UserNotesDesPageState();
}

class _UserNotesDesPageState extends State<UserNotesDesPage> {

  List<Tab> tabs = [
    const Tab(text: '全部',),
    const Tab(text: '划线',),
    const Tab(text: '高亮',),
    const Tab(text: '笔记',),
  ];

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('笔记详情'),
        ),
        body: DefaultTabController(
            length: tabs.length,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                BuildItem(model: widget.model),
                ClipRRect(
                  borderRadius:const BorderRadius.only(topLeft: Radius.circular(5),topRight: Radius.circular(5)),
                  child: Container(
                    width: double.infinity,
                    color: Colors.white,
                    height: 35.w,
                    child: TabBar(
                        indicator: UnderlineTabIndicator(
                          borderRadius: BorderRadius.circular(0.75),
                          borderSide: BorderSide(width: 1.5.w,color: AppTheme.primary),
                          insets: EdgeInsets.symmetric(horizontal: 22.w), // 设置标签下面指示器的水平内边距
                        ),
                        labelPadding: EdgeInsets.symmetric(horizontal: 20.w),
                        indicatorSize: TabBarIndicatorSize.label,
                        indicatorColor: AppTheme.primary,
                        indicatorWeight: 1.5,
                        labelStyle: TextStyle(color: AppTheme.primary,fontSize: 15.w,height: 1.5,fontWeight: Fonts.medium),
                        unselectedLabelColor: Colours.c9,
                        unselectedLabelStyle: TextStyle(color: Colours.c9,fontSize: 15.w,height: 1.5),
                        isScrollable: true,
                        tabs: tabs
                    ),
                  ),
                ),
                Expanded(
                  child: TabBarView(
                      children: List.generate(tabs.length, (index){
                        return BuildListPage(tag:'$index',model:widget.model);
                      })
                  ),
                )
              ],
            )
        ),
      );
  }
}
