part of apis;


abstract class LibraryAPI {

  /// 1、图书分类
  ///
  static Future <List<CategoryModel>> categories() async {
    final result = await HttpService.to.post(
      '/v1/book/category/getCategoryListAll',
      params: {},
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CategoryModel.fromJson(result.data['list'][index]);
    });
  }

  /// 2、图书标签
  ///
  static Future <List<LabelModel>> labels() async {
    final result = await HttpService.to.post(
      '/v1/book/category/getLabelListAll',
      params: {},
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return LabelModel.fromJson(result.data['list'][index]);
    });
  }

  /// 3、书籍列表
  ///
  static Future <List<CourseModel>> books({
    int page = 1,
    int limit = 10,
    String sortField = '',
    String sort = '',
    String isFree = '',
    String labelId = '',
    required String categoryId
  }) async {
    Map<String,dynamic> params = {
      'page' : page,
      'limit' : limit,
      'category_id':categoryId
    };
    if (sortField.isNotEmpty){
      params['sort_field'] = sortField;
    }
    if (sort.isNotEmpty){
      params['sort'] = sort;
    }
    if (isFree.isNotEmpty){
      params['is_free'] = isFree;
    }
    if (sort.isNotEmpty){
      params['sort'] = sort;
    }
    if (labelId.isNotEmpty){
      params['label_id'] = labelId;
    }


    final result = await HttpService.to.post(
      '/v1/book/category/getBookList',
      params: params,
      showLoading: true
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }

  /// 4、评分及书评
  ///
  static Future <List<ScoreModel>> scores({
    int page = 1,
    int limit = 10,
    required String bookId
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/getBookCommentList',
      params: {
        'page': page,
        'page_size': limit,
        'book_id':bookId
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return ScoreModel.fromJson(result.data['list'][index]);
    });
  }

  /// 5、获取书籍目录
  ///
  static Future <List<ChapterModel>> chapters({
    required String bookId
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/getBookChapter',
      params: {
        'book_id':bookId
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return ChapterModel.fromJson(result.data['list'][index]);
    });
  }

  /// 6、获取书籍详情
  ///
  static Future <BookDetailModel> details({
    required String bookId
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/getBookInformation',
      params: {
        'book_id':bookId
      },
    );
    if (result.data is! Map) return BookDetailModel();
    return BookDetailModel.fromJson(result.data);
  }

  /// 6、学习报告
  ///
  static Future <ReportModel> report({
    required String bookId
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myStudyReport',
      params: {
        'book_id':bookId
      },
    );
    if (result.data is! Map) return ReportModel();
    return ReportModel.fromJson(result.data);
  }

  /// 7、阅读页 章节笔记列表
  ///
  static Future<List<NoteModel>> noteList(
      {int page = 1,
        int limit = 10,
        required String bookId,
        required String chapterId}) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/getChapterNotesList',
      params: {
        'page': page,
        'page_size': limit,
        'book_id': bookId,
        'chapter_id': chapterId
      },
      // showLoading: true
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index) {
      return NoteModel.fromJson(result.data['list'][index]);
    });
  }

  /// 8、阅读页 章节讨论列表
  ///
  static Future<List<DiscussModel>> discussList(
      {int page = 1,
        int limit = 10,
        required String bookId,
        required String chapterId}) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/getChapterCommentList',
      params: {
        'page': page,
        'page_size': limit,
        'book_id': bookId,
        'chapter_id': chapterId
      },
      // showLoading: true,
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index) {
      return DiscussModel.fromJson(result.data['list'][index]);
    });
  }

  /// 9、添加阅读时长
  static Future <bool> addReadTime({
    required String bookId,
    required String readTypes
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/addReadTime',
      params: {
        'book_id':bookId,
        'read_types':readTypes
      },
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 10、发布讨论回复
  static Future <Map<String,dynamic>> addDiscuss({
    required String bookId,
    required String chapterId,
    required String commentId,
    required String quoteContent,
    required String title,
    required String content,
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/addComment',
      params: {
        'book_id':bookId,
        'chapter_id':chapterId,
        'comment_id':commentId,
        'quote_content':quoteContent,
        'title':title,
        'content':content
      },
        showLoading: true
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return result.data;
    }
    return {};
  }

  /// 11、获取离线书籍下载地址 和 秘钥串
  static Future <BookDownloadModel> getbookDownloadParam({
    required String bookId,
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/bookDownload',
      params: {
        'book_id':bookId,
      },
    );
    if (result.data is! Map) return BookDownloadModel();
    return BookDownloadModel.fromJson(result.data);
  }

  /// 12、根据书籍地址下载书籍
  static Future <void> downBookByUrl({
    required String url,
    required String savePath,
    ProgressCallback? onReceiveProgress,
  }) async {
    await HttpService.to.download(url, savePath: savePath,onReceiveProgress: onReceiveProgress);
  }

  /// 13、离线重连 上传笔记、高亮、划线
  static Future <bool> uploadContent({
    required String bookId,
    required String readTypes
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/addOfflineNotes',
      params: {
        'book_id':bookId,
      },
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 14、添加笔记、高亮、划线的内容
  static Future <bool> addNote({
    required String bookId,
    required String chapterId,
    String types = '3',
    required String content,
    required String isOpen,
    String color= '#FF0000',
    required String positioning,
    required String noteContent,
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/addNotes',
      params: {
        'book_id':bookId,
        'chapter_id':chapterId,
        'types':types,
        'content':content,
        'is_open':isOpen,
        'color':color,
        'positioning':positioning,
        'note_content':noteContent

      },
      showLoading: true
    );
    if (result.data is Map && result.data['id']!= ''){
      return true;
    }
    return false;
  }

  /// 15、批量上传离线笔记、高亮、划线的内容
  static Future <bool> uploadOffline({
    required String node,
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/addOfflineNotes',
      params: {
        'nodes_list':node,
      },
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 16、 搜索全文
  static Future<List<SearchAllModel>> searchAll({
    int page = 1,
    int limit = 10,
    required String bookId,
    required String key
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/searchContent',
      params: {
        'page': page,
        'page_size': limit,
        'book_id': bookId,
        'key': key
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index) {
      return SearchAllModel.fromJson(result.data['list'][index]);
    });
  }

  /// 17、评论 点赞 取消
  static Future <bool> commentLove({
    required num bookId,
    required num type,
    required num commentId,
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/clickPraise',
      params: {
        'book_id':bookId,
        'type':type,
        'comment_id':commentId
      },
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }
  /// 18、删除讨论回复
  static Future <bool> delComment({
    required num bookId,
    required num commentId,
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/delComment',
      params: {
        'book_id':bookId,
        'comment_id':commentId
      },
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }


}