part of widgets;

class CustomPullScrollView extends StatelessWidget {
  final EasyRefreshController controller;
  final bool refreshOnStart;
  final Widget? child;
  final void Function()? onRefresh;
  final void Function()? onLoading;

  const CustomPullScrollView({
    Key? key,
    required this.controller,
    this.refreshOnStart = true,
    this.onRefresh,
    this.onLoading,
    this.child,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return EasyRefresh(
      header: const ClassicHeader(showText: false
      ),
      footer: const ClassicFooter(showText: false,noMoreIcon: SizedBox()),
      controller: controller,
      onRefresh: onRefresh,
      onLoad: onLoading,
      refreshOnStart: refreshOnStart,
      child: child,
    );
  }
}
