part of user_order;
/// 紫荆币item
class BuiltCoin extends StatelessWidget {
  final OrderListModel model;

  const BuiltCoin({Key? key, required this.model}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    String status = '已完成';
    if(model.status==1){
      status ='待支付';
    }else if(model.status==2){
      status ='已取消';
    }else if(model.status==3){
      status ='已完成';
    }
    return GestureDetector(
      onTap: () {
        if(model.status == 1){
          context.pushNamed(Routes.orderCoinAwaiting,
              queryParameters: {'orderNum': model.ordersnum});
        }
      },
      child: Container(
        margin: EdgeInsets.only(left: 10.w, right: 10.w, top: 10.w),
        padding: EdgeInsets.only(left: 11.5.w),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(8.w),
          color: Colors.white,
          boxShadow: [
            BoxShadow(
              color: const Color(0xFFC7C7C7).withOpacity(0.5),
              offset: Offset(1.5.w, 0),
              blurRadius: 7.w,
              spreadRadius: 0.w,
            ),
          ],
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Container(
              margin: EdgeInsets.only(top: 19.w, bottom: 19.w, right: 16.5.w),
              child: Image.asset(
                'assets/images/coin.png',
                height: 30.w,
                width: 30.w,
                fit: BoxFit.cover,
              ),
            ),
            Expanded(
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        SizedBox(
                          height: 12.w,
                        ),
                        Text(
                          model.createTime.toString(),
                          style: TextStyle(fontSize: 12.w, color: Colours.c9),
                        ),
                        SizedBox(
                          height: 4.w,
                        ),
                        Text(
                          '充值紫荆币',
                          style: TextStyle(
                              fontSize: 13.w,
                              color: Colours.c3,
                              fontWeight: Fonts.medium),
                        )
                      ],
                    ),
                    Container(
                      margin: EdgeInsets.only(right: 15.w),
                      child:  Column(
                        crossAxisAlignment: CrossAxisAlignment.end,
                        children: [
                          SizedBox(
                            height: 6.5.w,
                          ),
                          Text(status, style: TextStyle(fontSize: 13.w, color: Colours.c9),),
                          SizedBox(height: 6.5.w,),
                          Text(
                            '¥${model.finalTotalPrice}',
                            style: TextStyle(
                                fontSize: 14.w,
                                color: Colours.cAB1941,
                                fontWeight: Fonts.medium),
                          )
                        ],
                      ),
                    ),

                  ],
                )),
          ],
        ),
      ),
    );
  }
}
