part of apis;


abstract class LibraryAPI {

  /// 1、图书分类
  ///
  static Future <List<CategoryModel>> categoryList() async {
    final result = await HttpService.to.post(
      '/v1/book/category/getCategoryListAll',
      params: {},
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CategoryModel.fromJson(result.data['list'][index]);
    });
  }

  /// 2、图书标签
  ///
  static Future <List<LabelModel>> labelList() async {
    final result = await HttpService.to.post(
      '/v1/book/category/getLabelListAll',
      params: {},
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return LabelModel.fromJson(result.data['list'][index]);
    });
  }

  /// 3、书籍列表
  static Future <List<CourseModel>> bookList({
    int page = 1,
    int limit = 20,
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/category/getBookList',
      params: {
        'currentPage': page,
        'pageSize': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }



}