part of user_order_awaiting;

/// 等待付款订单
class UserOrderAwaitingController extends GetxController {
  late String _orderNum;
  final BuildContext context;

  UserOrderAwaitingController(this.context); // 订单编号

  late OrderInfoModel model;
  // 应付款、订单编号等
  List<OrderCompletedModel> orderAwaitings = [];

  // 支付宝
  Tobias tobias = Tobias();
  // 微信
  Fluwx fluwx  = Fluwx();

  late PayOrderModel payOrderModel;

  String get orderNum => _orderNum; // 获取订单编号的方法

  // 更新订单编号的方法
  void updateOrderNum(String newOrderNum) {
    _orderNum = newOrderNum;
  }

  @override
  void onReady() {
    getOrderInfo();
    super.onReady();
  }

  ///  取消订单
  void cancelPay() async {
    final result = await MineAPI.cancelPay(ordersnum: orderNum);
    if (result) {
      Toast.show('取消成功');
      update();
    }
  }




  /// 获取订单信息
  Future<void> getOrderInfo() async {
    model = await MineAPI.getOrderInfo(orderNum: orderNum);
    String payWay ='';
    if(model.payType==1){
      payWay='微信';
    }else  if(model.payType==2){
      payWay='支付宝';
    }else  if(model.payType==3){
      payWay='紫荆币';
    }
    orderAwaitings = [
      OrderCompletedModel(name: '订单编号',value: model.ordersnum.toString()),
      OrderCompletedModel(name: '支付方式',value: payWay),
      OrderCompletedModel(name: '支付时间',value: model.payTime.toString()),
    ];

    update();
  }

  Future<void> payOrder() async {
    payOrderModel = await MineAPI.getPayInfo(ordersNum: orderNum);
    // 支付宝
    if (model.payType == 2){
      final result = await tobias.isAliPayInstalled;
      if(!result){
        Toast.show('请先安装支付宝');
      }
      else{
        requestAliPay();
      }
    }
    // 微信
    if (model.payType ==1){
      final result = await fluwx.isWeChatInstalled;
      if(!result){
        Toast.show('请先安装微信');
      }
      else{
        requestWechat();
      }
    }
    // if (model.payType == 3){
    //   final result = await MineAPI.coinPay(ordersNum: orderNum);
    //   if (result){
    //     Toast.show('订单支付完成');
    //     getOrderInfo();
    //   }
    // }
    // else{
    //
    // }
  }

  // 支付宝支付
  void requestAliPay(){

    print('================================================================${payOrderModel.encryptionOrder!}');
    tobias.pay(payOrderModel.encryptionOrder!).then((payResult){
      if (payResult['resultStatus'] == '9000') {
        requestOrderStatus();
      } else {
        Toast.show(payResult['memo'].toString());
      }
    });
  }

  // 微信支付
  void requestWechat(){
    Payment payment = Payment(
        appId: payOrderModel.appid??'',
        partnerId: payOrderModel.partnerid??'',
        prepayId: payOrderModel.prepayid??'',
        packageValue: payOrderModel.package??'',
        nonceStr: payOrderModel.noncestr??'',
        timestamp: payOrderModel.timestamp!.toInt(),
        sign: payOrderModel.sign??''
    );
    fluwx.pay(which: payment);
    fluwx.addSubscriber((response) {
      if (response.errCode == 0) {
        requestOrderStatus();
      }
      else{
        Toast.show('${response.errStr}');
      }
    });
  }

  void requestOrderStatus() async {
    final result = await ShopAPI.orderStatus(orderNumber: payOrderModel.ordersnum??'',receipt: '');
    if (result.paySuccess == 1){
      Toast.show('订单支付完成');
      context.pop();
    }

  }




}
