part of book_detail;



class BookDetailPage extends StatefulWidget {
  final String bookId;
  const BookDetailPage({
    Key? key,
    required this.bookId
  }) : super(key: key);

  @override
  State<BookDetailPage> createState() => _BookDetailPageState();
}

class _BookDetailPageState extends State<BookDetailPage> with SingleTickerProviderStateMixin{


  @override
  Widget build(BuildContext context) {
    return GetBuilder<BookDetailController>(
      init:BookDetailController(widget.bookId),
      builder: (controller)=> Scaffold(
        appBar:  CustomAppBar(
          backgroundColor: const Color(0xFFAB1941).withOpacity(0.02),
          title: const Text('详情'),
          actions: [
            CustomButton.icon(
              padding: EdgeInsets.zero,
              backgroundColor: Colors.transparent,
              icon: Image.asset('assets/images/shop.png'),
              onPressed: () => context.pushNamed(Routes.shop),
            ),
            CustomButton.icon(
              padding: EdgeInsets.zero,
              backgroundColor: Colors.transparent,
              icon: Image.asset(
                controller.bookDetails.isCollection == 0? 'assets/images/unlove.png':'assets/images/love.png',
              ),
              onPressed: () {
                controller.love(bookId: controller.bookDetails.bookId.toString(), isCollection: controller.bookDetails.isCollection!);
              },
            ),
          ],
        ),
        body:
        Column(
          children: [
            BuildBook(model: controller.bookDetails,),
            Container(
              height: 10.w,
              color: const Color(0xFFF9F9F9),
            ),
            BuildStudy(model:controller.bookDetails,),
            Container(
              height: 2,
              color: const Color(0xFFF9F9F9),
            ),
            Container(
              color: Colors.white,
              child: TabBar(
                labelColor: AppTheme.primary,
                // isScrollable: true,
                labelStyle: TextStyle(fontSize: 15.w,height: 1.4,fontWeight: Fonts.medium),
                unselectedLabelColor: Colours.c9,
                unselectedLabelStyle: TextStyle(fontSize: 15.w,height: 1.4),
                indicatorSize: TabBarIndicatorSize.label,
                indicatorColor: AppTheme.primary,
                tabs:controller.tabs,
                physics: const NeverScrollableScrollPhysics(),
                controller: controller.tabController,
              ),
            ),
            Expanded(
              child: TabBarView(
                controller: controller.tabController,
                children: [
                  BookCategoryPage(chapters: controller.chapters,),
                  Container(
                    padding: EdgeInsets.only(left: 15.w,right: 15.w,top:12.w),
                    color: Colors.white,
                    child: Text(controller.bookDetails.content??'',style: TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c3),),
                  ),
                  BookInfoPage(model:controller.bookDetails,)
                ],
              ),
            ),

          ],
        ),
        bottomNavigationBar: SafeArea(
          child: Container(
            color: Colors.white,
            padding: EdgeInsets.symmetric(horizontal: 15.w,vertical: 10.w),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
              children: [
                Expanded(
                  child: GestureDetector(
                    onTap: (){
                      if(controller.bookDetails.isHave ==1){
                        context.pushNamed(Routes.studyReport,queryParameters: {'book_id':widget.bookId});
                      }
                      else{
                        controller.addCart(widget.bookId);
                      }
                    },
                    child: Container(
                      alignment: Alignment.center,
                      height: 35,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(17.5.w),
                        border:Border.all(
                          width: 0.5,
                          color: Colours.c9
                        ),
                        // color: Colours.cE0.withOpacity(0.5),
                      ),
                      // padding: EdgeInsets.symmetric(vertical: 8),
                      child: controller.bookDetails.isHave ==1? Text('学习报告',style: TextStyle(fontSize: 13.w,color: Colours.c9,height: 1.5),):Text('加入书架',style: TextStyle(fontSize: 13.w,color: AppTheme.primary,height: 1.5),),
                    ),
                  ),
                ),
                Gaps.hGaps10,
                Expanded(
                  child: GestureDetector(
                    onTap: () async{
                      // context.pushNamed(Routes.creditPoints).then((value){
                      //   print('---------------------$value');
                      // });
                      /// 没有购买并且没有试读直接跳转 购买页
                      bool noTryRead = true;
                      if(controller.bookDetails.isHave == 0 && noTryRead){
                        List<CourseModel> buy = [];
                          CourseModel model= CourseModel(
                            bookId: controller.bookDetails.bookId,
                            price: controller.bookDetails.price,
                            vipPrice: controller.bookDetails.vipPrice,
                            img: controller.bookDetails.img,
                            bookName: controller.bookDetails.bookName,
                            cartId: 0,
                            status: 1,
                            selected: true
                          );
                          buy.add(model);

                          final  result =  await context.pushNamed(Routes.bookPay,extra: buy);
                          if (result == true) {
                            controller.getBookDetails();
                          }
                      }
                      else {
                        context.pushNamed(Routes.web);
                      }
                    },
                    child: Container(
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(17.5.w),
                        color: AppTheme.primary.withOpacity(0.1)
                      ),
                      height: 35.w,
                      alignment: Alignment.center,
                      padding:  EdgeInsets.symmetric(vertical: 8.w),
                      child:  Text('阅读',style: TextStyle(fontSize: 13.w,color: AppTheme.primary,height: 1.5),),
                    ),
                  ),
                )
              ],
            ),
          ),
        ),
      ),
    );

  }



}
