part of course;

class BuildBanner extends StatelessWidget {
  final List items;
  const BuildBanner({
    Key? key,
    this.items = const [],
  }) : super(key:key);

  @override
  Widget build(BuildContext context) {
    Random random = Random();
    return CarouselSlider(
      options: CarouselOptions(
        // 自动滚动
        autoPlay: items.length > 1,
        // 是否无限滚动
        enableInfiniteScroll: items.length > 1,
        // 居中的是否放大
        enlargeCenterPage: false,
        // 宽高比例
        aspectRatio: 19 / 9,
        // 是否占满满视图
        viewportFraction: 1,
      ),
      items: items.map((item) {
        return SafeArea(
          minimum: const EdgeInsets.symmetric(horizontal: 0).copyWith(bottom: 0),
          child: Container(
            width: double.infinity,
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8),
              color: Color.fromRGBO(
                random.nextInt(256), // Red
                random.nextInt(256), // Green
                random.nextInt(256), // Blue
                1.0, // Alpha (opacity)
              ),

            ),

            child: Text('$item'),
            // child: CustomImage.asset(
            //   url: 'assets/images/banner.png',
            //   width: 130.w,
            //   fit: BoxFit.contain,
            // ),
          ),
        );
      }).toList(),
    );
  }
}
