part of change_pwd;

class ChangePwdPage extends StatefulWidget {
  final String type;
  const ChangePwdPage({
    Key? key ,
    required this.type,
  }) : super(key: key);
  // const ResetPwdPage({Key? key}) : super(key: key);

  @override
  State<ChangePwdPage> createState() => _ChangePwdPageState();
}

class _ChangePwdPageState extends State<ChangePwdPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<ChangePwdController>(
      init: ChangePwdController(),
      builder: (controller) =>Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: Text(widget.type =='1'?'设置密码':'修改密码'),
        ),
        body: Container(
          margin: const EdgeInsets.only(left: 10,top: 15,right: 10),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              ValueListenableBuilder<bool>(
                valueListenable: controller.showPassword,
                builder:(context, value, child) => Container(
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(8),
                    color: const Color(0xFFF9F9F9),
                    boxShadow: [
                      BoxShadow(
                        color: const Color(0xFFC7C7C7).withOpacity(0.35),
                        offset: const Offset(3, 0),
                        blurRadius: 10.w,
                        spreadRadius: 0.w,
                      ),
                    ],
                  ),
                  child: ClipRRect(
                    borderRadius: BorderRadius.circular(8),
                    child: CustomFormInput(
                      obscureText: !value,
                      hintText: '请输入新密码',
                      iconData:
                      value ? Image.asset(
                        'assets/images/eye_open.png',
                      )  : Image.asset(
                        'assets/images/eye_close.png',
                      ),
                      controller: controller.pwdInput,
                      onChanged: (text){
                        controller.setCanClick();
                      },
                      decoration: const InputDecoration(
                          focusedBorder: InputBorder.none,
                          border: InputBorder.none,
                          enabledBorder: InputBorder.none,
                          errorBorder: InputBorder.none
                      ),
                      onIcon: controller.onShowPassword,
                    ),
                  ),
                ),
              ),
              Gaps.vGaps10,
              ValueListenableBuilder<bool>(
                valueListenable: controller.showPassword2,
                builder:(context, value, child) => Container(
                  decoration: BoxDecoration(
                    // borderRadius: BorderRadius.circular(8),
                    color: const Color(0xFFF9F9F9),
                    boxShadow: [
                      BoxShadow(
                        color: const Color(0xFFC7C7C7).withOpacity(0.35),
                        offset: const Offset(3, 0),
                        blurRadius: 10.w,
                        spreadRadius: 0.w,
                      ),
                    ],
                  ),
                  child: ClipRRect(
                    borderRadius: BorderRadius.circular(8),
                    child: CustomFormInput(
                      obscureText: !value,
                      hintText: '请再次输入密码',
                      iconData:
                      value ? Image.asset(
                        'assets/images/eye_open.png',
                      )  : Image.asset(
                        'assets/images/eye_close.png',
                      ),
                      controller: controller.pwd2Input,
                      onChanged: (text){
                        controller.setCanClick();
                      },
                      decoration: const InputDecoration(
                          focusedBorder: InputBorder.none,
                          border: InputBorder.none,
                          enabledBorder: InputBorder.none,
                          errorBorder: InputBorder.none
                      ),
                      onIcon: controller.onShowPassword2,
                    ),
                  ),
                ),
              ),
              Container(
                margin: const EdgeInsets.only(left: 5,top: 5),
                child: const Text('密码必须是6-20个英文字母、数字或符号',style: TextStyle(fontSize: 10,color: Colours.c9),),
              ),
              Gaps.vGaps40,
              CustomGradientButton(
                text: widget.type == '1'?'确认':'确认修改',
                isEnabled: controller.enable,
                onPressed: () {
                  // context.goNamed(Routes.login);
                },
              )
            ],
          ),
        ),
      ),
    );
  }
}
