part of web;

class ReadController extends GetxController with GetSingleTickerProviderStateMixin{
  late AnimationController _controller;
  bool _show = false;


  bool get show => _show;
  void setShow(bool value) {
    _show = !value;
    if (_show) {
      SystemChrome.setEnabledSystemUIMode(SystemUiMode.edgeToEdge);
      _controller.forward();
    }
    else {
      SystemChrome.setEnabledSystemUIMode(SystemUiMode.immersiveSticky);
      _controller.reverse();
    }
    update();
  }


  AnimationController get controller => _controller;


  @override
  void onInit() {
    SystemChrome.setEnabledSystemUIMode(SystemUiMode.immersiveSticky);
    _controller = AnimationController(
      vsync: this,
      duration: const Duration(milliseconds: 100),
    );
    super.onInit();
  }

  @override
  void onClose() {
    _controller.dispose();
    super.onClose();
  }
}