part of book_info;

class BookInfoPage extends StatelessWidget {
  final BookDetailModel model;
  const BookInfoPage({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      color: Colors.white,
      padding: EdgeInsets.symmetric(horizontal: 15.w,vertical: 18.w),
      child: SingleChildScrollView(
        child: Column(
          children: [
            // 评分容器
            Column(
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Text('评分及书评',style: TextStyle(fontSize: 14.w,color: Colours.c3,height: 1.6,fontWeight: Fonts.medium),),
                    Row(
                        children: [
                          GestureDetector(
                            child: Text('查看全部',style: TextStyle(fontSize: 11.w,color: Colours.c9),),
                            onTap: (){
                              context.pushNamed(Routes.bookScore,queryParameters: {'book_id':'110'});
                            },
                          ),
                          Gaps.hGaps5,
                          SizedBox(
                            width: 5.w,
                            height: 8.w,
                            // color: Colors.cyan,
                            child: Image.asset(
                              'assets/images/right_arrow.png',
                            ),
                          )
                        ]
                    )
                  ],
                ),
                Container(
                  margin: EdgeInsets.symmetric(vertical: 10.w),
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      Column(
                        mainAxisAlignment: MainAxisAlignment.center,
                        // crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          Text(model.rating??'',style: TextStyle(fontSize: 35.w,height: 1.5.w,fontWeight: Fonts.boldSemi,color: AppTheme.primary),),
                          AbsorbPointer(
                            absorbing: true,
                            child: CustomRating(
                              max: 5,
                              score:model.rating !=null ?double.parse(model.rating!):0,
                              star: Star(
                                progress: 7,
                                fillColor: AppTheme.primary,
                                size: 12.w,
                                emptyColor: Colours.cE2,
                              ), onRating: (double a) {},
                            ),
                          ),
                        ],
                      ),
                      Expanded(
                        child: SizedBox(
                          height: 90,
                          // color: Colors.green,
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.end,
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: [
                              Column(
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  crossAxisAlignment: CrossAxisAlignment.end,
                                  children: List.generate(model.ratingList!.length, (index){
                                    return _buildProgrss(5- index.toDouble(), model.ratingList![index].toDouble()/model.ratingCount!);
                                  }).toList()
                              ),
                              Text('${model.ratingCount}个评分',style: TextStyle(fontSize: 9.w,height: 1.4,color: Colours.c9),)
                            ],
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
              ],
            ),
            Container(height: 1,width: double.infinity,color: Colours.cF2,),
            Gaps.vGaps15,
            // 书籍信息
            Column(
              mainAxisAlignment: MainAxisAlignment.end,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                {'name':'书名','value':model.bookName},
                {'name':'作者','value':model.authors},
                {'name':'分类','value':model.categoryName},
                {'name':'出品方','value':model.producersName},
                {'name':'出版社','value':model.pressName},
                {'name':'上架时间','value':Tools.dateFromMS(model.onsaleTime!.toInt(),pattern:'yyyy年MM月dd日' )},
              ].map((item){
                return Row(
                  children: [
                    Container(
                      // color: Colors.cyan,
                      alignment: Alignment.centerRight,
                      width: 60.w,
                      child: Text(item['name'].toString(),style: const TextStyle(fontSize: 15,height: 2.1,color: Colours.c3),),
                    ),
                    Gaps.hGaps20,
                    Container(
                      alignment: Alignment.centerLeft,
                      child: Text(item['value'].toString(),style: const TextStyle(fontSize: 15,height: 2.1,color: Colours.c9),textAlign: TextAlign.end,),
                    ),
                  ],
                );
              }).toList(),
            )
          ],
        ),
      ),
    );
  }

  Widget _buildProgrss(double num, double value) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.end,
      children: [
        StarScore(
          score: num,
          star: Star(
              fillColor: Colours.cE2,
              size: 12,
              emptyColor: Colours.cE2,
          ),
        ),
        ClipRRect(
          borderRadius: BorderRadius.circular(2.5),
          child: SizedBox(
            width: 100,
            height: 5,
            child: LinearProgressIndicator(
              value: value, // 设置进度值（0.0 到 1.0）
              color: AppTheme.primary, // 设置进度条颜色
              backgroundColor: Colours.cE2, // 设置背景颜色
            ),
          ),
        ),
      ]
    );
  }
}
