part of library;

class LibraryPage extends StatefulWidget {
  const LibraryPage({Key? key}) : super(key: key);

  @override
  State<LibraryPage> createState() => _LibraryPageState();
}

class _LibraryPageState extends State<LibraryPage>  {

  @override
  Widget build(BuildContext context) {
    return GetBuilder<LibraryController>(
      init: LibraryController(),
        builder: (controller) => Scaffold(
          appBar: AppBar(
            title: const Text('图书馆'),
            actions: [
              IconButton(
                icon: const Icon(Icons.search_rounded),
                tooltip: 'Open shopping cart',
                onPressed: () {
                  context.pushNamed(Routes.search);
                },
              ),
            ],
          ),
          body: _buildBody(controller)
        ),
    );
  }

  Widget _buildBody(LibraryController controller){
    return Stack(
      children: [
        Column(
          children: [
            _buildTab(controller),
            _buildLabel(),
            GetBuilder<LibraryContentController>(
              init: LibraryContentController(),
              builder:(contentController)=> Expanded(
                child: CustomPullScrollView(
                  controller: contentController.refreshController,
                  onRefresh: contentController.onRefresh,
                  onLoading: contentController.onLoading,
                  child: CustomScrollView(
                    slivers: [
                      // 广告位
                      SliverToBoxAdapter(
                        child: Container(
                          color: Colors.red,
                          padding: EdgeInsets.symmetric(horizontal: 10.w),
                          child: BuildBanner(items: controller.ads,),
                        ),
                      ),
                      SliverFillRemaining(
                        child: TabBarView(
                            controller: controller.tabController,
                            children: List.generate(controller.categories.length, (index){
                              print('=======================================$index');
                              return LibraryContentPage(controller: contentController,);
                            })
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            ),
          ],
        ),
        Visibility(
          visible: controller.show,
          child: FilterPage(
            controller: controller,
            sureTap: (){
              controller.setShow(controller.show);
            },
            resetTap: (){

            },),
        ),
      ],
    );
  }

  Widget _buildLabel(){
    return Container(
      height: 43.w,
      color: Colours.cF9,
      child: GetBuilder<LibraryController>(
        init: LibraryController(),
        // id: 'label',
        builder:(controller) =>ListView.builder(
          scrollDirection:Axis.horizontal ,
          itemBuilder: (BuildContext context, int index){
            return GestureDetector(
              child: BuildLabelWidget(model: controller.labels[index],),
              onTap: (){
                controller.selectLabel( controller.labels[index]);
              },
            );
          },
          itemCount: controller.labels.length,
        ),
      ),
    );
  }

  PreferredSizeWidget _buildTab(LibraryController controller){
    return PreferredSize(
      preferredSize: Size.fromHeight(48.w),
      child: Container(
        color: Colors.white,
        child: Row(
          children: [
            // TabBar放在左侧
            Expanded(
              child: TabBar(
                indicator: BoxDecoration(
                    border: const Border(bottom: BorderSide(color: Colors.transparent, width: 0.0)), // 将指示器的底边框颜色设置为透明
                    color: const Color(0xFFC02D55).withOpacity(0.08)
                ),
                labelStyle: TextStyle(color: AppTheme.primary,fontSize: 14.w,height: 1.5,fontWeight: Fonts.medium),
                unselectedLabelColor: Colours.c9,
                unselectedLabelStyle:  TextStyle(color: Colours.c9,fontSize: 14.w,height: 1.5),
                controller: controller.tabController,
                isScrollable: true,
                tabs: controller.categories.map((model){
                  return Tab(text: model.name);
                }).toList(),
              ),
            ),
            // 筛选按钮放在右侧
            GestureDetector(
              onTap: (){
                controller.setShow(controller.show);
              },
              child: Container(
                padding: EdgeInsets.symmetric(horizontal: 10.w),
                alignment: Alignment.center,
                height: 38.w,
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Container(
                      width: 12.w,
                      height: 12.w,
                      // color: Colors.red,
                      alignment: Alignment.center,
                      child: Image.asset(
                        'assets/images/filter.png',
                      ),
                    ),
                    Gaps.hGaps5,
                    Text('筛选',style: TextStyle(color: Colours.c9,fontSize: 14.w,height: 1.5),)
                  ],
                ),
                // width: 75,
              ),
            )
          ],
        ),
      ),
    );
  }
  // @override
  // bool get wantKeepAlive => true;
}
