part of book_shop;

enum BookCellType {
  normal,
  pay,
}

class BookCell extends StatelessWidget {
  final BookCellType? type;

  const BookCell({
    super.key,
    this.type = BookCellType.normal,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
          borderRadius:BorderRadius.circular(5),
          color: Colors.white,
          boxShadow: [
            BoxShadow(
              color: Color(0xFFC7C7C7).withOpacity(0.5),
              spreadRadius: 2,
              blurRadius: 5,
              offset: Offset(3, 0), // changes the position of the shadow
            ),
          ]
      ),
      margin: const EdgeInsets.only(left: 10,right: 10,top: 10),
      height: 110,
      child: Row(
       children: [
         ///左侧
         Container(
           margin: const EdgeInsets.only(left: 12,right: 11),
           child: Row(
             children: [
               type == BookCellType.normal?Container(
                 height: 17,
                 width: 17,
                 color: Colors.cyan,
               ):const SizedBox(),
               type == BookCellType.normal?const SizedBox(width: 12,):const SizedBox(),
               Container(
                 decoration: BoxDecoration(
                     color: Colors.cyan,
                   borderRadius: BorderRadius.circular(3),
                     boxShadow: [
                       BoxShadow(
                         color: Color(0xFF707070).withOpacity(0.5),
                         spreadRadius: 2,
                         blurRadius: 5,
                         offset: Offset(3, 0), // changes the position of the shadow
                       ),
                     ]
                 ),
                 // color: Colors.white,
                 height: 86,
                 width: 72,
                 child: Container(
                   padding: EdgeInsets.all(2),
                   child: Container(
                     color: Colors.cyan,
                   ),
                 ),

               )
             ],
           ),
         ),
         ///右侧
         Expanded(
           child: Container(
             padding: const EdgeInsets.only(top: 12,bottom: 10),
              child: const Column(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text('一想到还有95%的问题留给人类，我就放一想到还有95%的问题留给人类，我就放一想到还有95%的问题留给人类，我就放',style: TextStyle(fontSize: 13,fontWeight: FontWeight.w500,color: Color(0xFF333333)),maxLines: 2,overflow: TextOverflow.ellipsis,),
                      SizedBox(height: 5,),
                      Text('威廉·莎士比亚',style: TextStyle(fontSize: 11,fontWeight: FontWeight.w400,color: Color(0xFF999999))),
                    ],
                  ),
                  Text('￥88',style: TextStyle(fontSize: 14,fontWeight: FontWeight.w500,color: AppTheme.primary)),
                ],
              ),
           ),
         )
       ],
      )
    );
  }
}
