part of login;


enum LoginType{code, password}

class LoginController extends GetxController {

  // 0：密码登录  1：验证码登录
  late int loginType = 0;
  // 2、密码登录
  // 账号
  final TextEditingController phoneInput = TextEditingController();
  // 密码
  final TextEditingController passwordInput = TextEditingController();
  // 验证码
  final TextEditingController codeInput = TextEditingController();
  // 显示密码
  final ValueNotifier<bool> showPassword = ValueNotifier(false);
  // 定时器
  late Timer _timer;

  // 按钮是否可用
  bool  _enable = false;
  bool get enable => _enable;

  // 倒计时60秒
  int _countDown = 60;
  int get countDown => _countDown;
  bool _isCounting = false;
  bool get isCounting => _isCounting;

  // 同意协议
  bool _agree = false;
  bool get agree => _agree;
  void setAgree() {
    _agree = !_agree;
  }

  // 开启定时器
  void start() {
    _isCounting = true;
    _timer = Timer.periodic(const Duration(seconds: 1), (timer) {
      if (_countDown > 1) {
        _countDown--;
      } else {
        stop();
      }
      update();
    });
  }

  // 停止计时器
  void stop() {
    if (_timer != null){
      _timer.cancel();
      _isCounting = false;
    }
    _countDown = 60;
  }

  void setCanClick(){
    if (phoneInput.text.length == 11 && passwordInput.text.length == 4){
      _enable = true;
    }
    else{
      _enable = false;
    }
    update();
  }


  @override
  void onInit() {
    _timer = Timer.periodic(const Duration(seconds: 1), (timer) {
      // 定时器回调
    });
    /// 测试账号
    if (kDebugMode) {
       phoneInput.text = '13521054068';
       passwordInput.text = '123456';
    }
    super.onInit();
  }

  @override
  void onClose() {
    phoneInput.dispose();
    passwordInput.dispose();
    showPassword.dispose();
    codeInput.dispose();
    _timer.cancel();
    _isCounting = false;
    super.onClose();
  }

  void onShowPassword() => showPassword.value = !showPassword.value;

  void updateLoginType(int value){
    stop();
    loginType = value;
    update();
  }

  Future<bool> onLogin(GlobalKey<FormState> key) async {

    final result = AccountAPI.login(
        phone: '',
        password: 'password',
        type: 'type'
    );

    /// 存储账号密码
    StorageService.to.setString(kLocalAccount, 'phone');
    StorageService.to.setString(kLocalPassword, 'password');

    /// 存储用户信息
    await Future.wait([
       UserStore.to.setToken(''),

    ]);


    // if (!context.mounted) return;
    // if (context.canPop()){
    //   context.pop();
    // }else {
    //   context.goNamed(Routes.main);
    // }

    return true;






  }

}