part of book_detail;

class BuildStudy extends StatefulWidget {
  final BookDetailModel model;
  const BuildStudy({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  State<BuildStudy> createState() => _BuildStudyState();
}

class _BuildStudyState extends State<BuildStudy> {
  @override
  Widget build(BuildContext context) {
    return Container(
      height: 50,
      color: Colors.white,
      child:Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: [
          Expanded(
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Text(widget.model.rating??'',style:const TextStyle(fontSize: 16,height: 1.5,fontWeight: Fonts.medium,color: AppTheme.primary)),
                    const Text('/5.0',style: TextStyle(fontSize: 13,height: 1.5,fontWeight: Fonts.medium,color: Colours.c9),)
                  ],
                ),
                AbsorbPointer(
                  absorbing: true,
                  child: CustomRating(
                    max: 5,
                    score:widget.model.rating !=null ?double.parse(widget.model.rating!):0,
                    star: const Star(
                      progress: 7,
                      fillColor: AppTheme.primary,
                      size: 12,
                      emptyColor: Colours.cE2,
                    ), onRating: (double a) {},
                  ),
                ),
              ],
            ),
          ),
          Expanded(
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                RichText(text:TextSpan(
                  children: [
                    TextSpan(
                      text: widget.model.readNum.toString(),
                      style: const TextStyle(fontSize: 16,color: Colours.c3,fontWeight: Fonts.medium,height: 1.3)
                    ),
                    // TextSpan(
                    //   text: '万',
                    //     style: TextStyle(fontSize: 16,color: Colours.c3,)
                    // )
                  ]
                )),
                const Text('学习次数', style: TextStyle(fontSize: 12,color: Colours.c9,height: 1.3)),
              ],
            ),
          )
        ],
      ) ,
    );
  }
}
