part of book_pay;

enum PayType {
  wechat(label: '微信',icon: ''),
  alipay(label: '支付宝',icon: ''),
  zijin(label: '紫荆币',icon: ''),;

  final String label;
  final String icon;

  const PayType({
    required this.label,
    required this.icon
  });
}


class BookPayPage extends StatefulWidget {
  const BookPayPage({Key? key}) : super(key: key);

  @override
  State<BookPayPage> createState() => _BookPayPageState();
}

class _BookPayPageState extends State<BookPayPage> {

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(title: const Text('支付'),),
      body: Column(
        children: [
          Expanded(
            child: SingleChildScrollView(
              child: Column(
                children: [
                  const BuildItem(),
                  const SizedBox(height: 10,),
                  Container(
                    height: 100,
                    color: Colors.lime,
                  ),
                  const SizedBox(height: 10,),
                  Container(
                    margin: EdgeInsets.symmetric(horizontal: 10),
                    color: Colors.white,
                    child: Column(
                      children: [
                        _creatPayItem(PayType.wechat),
                        Container(margin: EdgeInsets.symmetric(horizontal: 10),color: Color(0xFFF0F0F0),height: 1,),
                        _creatPayItem(PayType.alipay),
                        Container(margin: EdgeInsets.symmetric(horizontal: 10),color: Color(0xFFF0F0F0),height: 1,),
                        _creatPayItem(PayType.zijin)
                      ],
                    ),
                  )
                ],
              ),
            ),
          ),
          SafeArea(
            child: _creatPayWidget()
          )
        ],
      ),
    );
  }

  /// 确认支付组件
  Widget _creatPayWidget(){
    return Container(
      padding: const EdgeInsets.symmetric(horizontal: 15),
      height: 50,
      // color: Colors.cyan,
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          const Row(
            children: [
              Text('应付：',style: TextStyle(fontSize:11,color: Color(0xFF333333) ),),
              Text('￥98.9',style: TextStyle(fontSize:13,color:AppTheme.primary,fontWeight: FontWeight.w500 ),)
            ],
          ),
          Container(
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(15),
              color: Colors.indigo
            ),
            padding: const EdgeInsets.symmetric(horizontal:13.5,vertical: 5),
            child: const Text('确认支付',style: TextStyle(fontSize: 12,fontWeight: FontWeight.w500,color: Colors.white),),
          )
        ],
      ),
    );
  }

  /// 支付小组件
  Widget _creatPayItem(PayType type){
    return Container(
      padding: EdgeInsets.symmetric(horizontal: 14),
        // color: Colors.red,
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Container(
              child: Row(
                children: [
                  Container(
                    margin: EdgeInsets.symmetric(vertical: 10),
                    color: Colors.cyan,
                    width:20,
                    height:20,
                  ),
                  SizedBox(width: 7,),
                  Text('${type.label}',style: TextStyle(fontSize: 12,color: Color(0xFF333333)))
                ],
              ),
            ),
            Container(
              color: Colors.cyan,
              width:15,
              height:15,
            )
          ],
      )
    );
  }

}
