part of book_shop;

class BookShopPage extends StatefulWidget {
  const BookShopPage({Key? key}) : super(key: key);

  @override
  State<BookShopPage> createState() => _BookShopPageState();
}

class _BookShopPageState extends State<BookShopPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<BookshopController>(
      init: BookshopController(),
      builder: (controller) => Scaffold(
        appBar: AppBar(
          title: const Text('书架'),
        ),
        body: Column(
          children: [
            Expanded(
              child: CustomPullScrollView(
                controller: controller.refreshController,
                onRefresh: controller.onRefresh,
                onLoading: controller.onLoading,
                child: ListView.builder(
                    itemBuilder: (BuildContext context,int index){
                      CourseModel model = controller.carts[index];
                      return BookCell(model:model ,onTap: (){
                          controller.delCart(cartId: model.cartId.toString());
                      },);
                    },
                  itemCount: controller.carts.length,
                ),
              ),
            ),
            BuildCounter()
          ],
        ),
      ),
    );
  }

}
