part of user_discuss;

class BuildItem extends StatelessWidget {
  final CourseModel model;
  final int index;
  final int num;
  const BuildItem({
    Key? key,
    required this.model,
    required this.index,
    required this.num
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.symmetric(horizontal: 10),
      padding: const EdgeInsets.symmetric(horizontal: 10),
      // margin: const EdgeInsets.all(10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8),
        color: Colors.white,
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: const Offset(3, 0),
            blurRadius: 10.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      child: Column(
        children: [
          index == 0 ? Container(
            // padding: const EdgeInsets.only(left: 10),
            height: 32,
            width: double.infinity,
            decoration: const BoxDecoration(
              borderRadius: BorderRadius.only(
                topLeft: Radius.circular(8),
                topRight: Radius.circular(8),
              ),
              color: Colors.white,
            ),
            alignment: Alignment.centerLeft,
            child: Text('共$num本书',style: const TextStyle(fontSize: 13,height: 1.5,color: Colours.c6),),
          ):const SizedBox(),
          Container(
            height: 0.5,
            color: Colours.cF0,
          ),
          Container(
            padding: const EdgeInsets.only(top: 12,bottom: 15),
            // color: Colors.red,
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Container(
                  height: 87,
                  width: 73,
                  color: Colors.cyan,
                ),
                Container(
                  height: 87,
                  margin: const EdgeInsets.only(left: 13),
                  // color: Colors.green,
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(model.bookName??'',style: const TextStyle(fontSize: 14,height: 1.5,fontWeight: Fonts.medium,color: Colours.c3),),
                          Text(model.authors??'',style: const TextStyle(fontSize: 12,height: 1.5,color: Colours.c6),),
                        ],
                      ),
                      Text('${model.commentNum.toString()}讨论',style: const TextStyle(fontSize: 11,height: 1.5,color: AppTheme.primary)),
                    ],
                  ),
                )
              ],
            ),
          )
        ],
      ),
    );
  }
}
