part of user_wrong;

class UserWrongPage extends StatefulWidget {
  const UserWrongPage({Key? key}) : super(key: key);

  @override
  State<UserWrongPage> createState() => _UserWrongPageState();
}

class _UserWrongPageState extends State<UserWrongPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserWrongController>(
      init: UserWrongController(),
      builder:(controller)=> Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('错题'),
        ),
        body: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Container(
                margin: EdgeInsets.only(left: 22.5.w,top: 16.w),
                child: Text('共${controller.wrongs.length}本书',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c6,fontWeight: Fonts.medium),)
            ),
            Expanded(
              child: CustomPullScrollView(
                  controller: controller.refreshController,
                  onRefresh: controller.onRefresh,
                  onLoading: controller.onLoading,
                  child:ListView.builder(
                    itemBuilder: (BuildContext context, int index){
                      return GestureDetector(
                        onTap: (){
                          context.pushNamed(Routes.wrongDes,extra: controller.wrongs[index]);
                        },
                          child: BuildItem(model: controller.wrongs[index],index: index,num: controller.wrongs.length,)
                      );
                    },
                    itemCount: controller.wrongs.length,
                  )
              ),
            ),
          ],
        ),
      ),
    );
  }
}
