part of apis;

abstract class AccountAPI {
  static Future <UserModel> login({
    required String phone,
    required String password,
    required String type,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/login/login',
      excludeToken: true,
      showLoading: true,
      params: {
        'phone': phone,
        'password': password,
        'type': type
      },
    );
    if (result.data is! Map) return UserModel();
    return UserModel.fromJson(result.data);
  }
}