part of course;

class CoursePage extends StatefulWidget {
  const CoursePage({Key? key}) : super(key: key);

  @override
  State<CoursePage> createState() => _CoursePageState();
}

class _CoursePageState extends State<CoursePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<CourseController>(
      init: CourseController(),
      builder: (controller) =>Scaffold(
          appBar: CustomAppBar(
            titleSpacing: 0,
            title:  Padding(
              padding: EdgeInsets.symmetric(horizontal: AppTheme.margin),
              child: CustomInputSearch(
                readOnly:true,
                hintText: '请输入书籍名称',
                onTap: () {
                  context.pushNamed(Routes.msgs);
                }
              ),
            ),
            actions: [
              CustomButton.icon(
                padding: EdgeInsets.zero,
                backgroundColor: Colors.transparent,
                icon: const Icon(Ionicons.timer),
                onPressed: () => context.pushNamed(Routes.msgs),
              ),
              badges.Badge(
                position: badges.BadgePosition.topEnd(top: -5, end: 0),
                badgeContent: Text('10',style: TextStyle(fontSize: 7,color: Colors.white),),
                badgeStyle: badges.BadgeStyle(
                  badgeColor: AppTheme.primary,
                  shape: badges.BadgeShape.circle
                ),
                child: CustomButton.icon(
                    padding: EdgeInsets.zero,
                    backgroundColor: Colors.transparent,
                    icon: const Icon(Ionicons.notifications),
                    onPressed: () => context.pushNamed(Routes.msgs),
                  ),
              )
              // CustomButton.icon(
              //   padding: EdgeInsets.zero,
              //   backgroundColor: Colors.transparent,
              //   icon: const Icon(Ionicons.notifications),
              //   onPressed: () => context.pushNamed(Routes.msgs),
              // ),
            ],
          ),
          body:Column(
            children: [
              const BuildBanner(items: ['111','222','333'],),
              Expanded(
                child: CustomPullScrollView(
                  controller: controller.refreshController,
                  onRefresh: controller.onRefresh,
                  onLoading: controller.onLoading,
                  child: GridView.builder(
                      gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                          crossAxisCount: 2,
                        crossAxisSpacing: 10,
                        mainAxisSpacing: 10,
                        childAspectRatio: 1.5
                      ),
                      itemBuilder: (BuildContext context, int index) {
                        return createCellWidget();
                      },
                     itemCount: 10,
                  ),
                  // builder: (context,physics) => GridView.builder(
                  //     gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                  //         crossAxisCount: 2,
                  //       crossAxisSpacing: 10,
                  //       mainAxisSpacing: 10,
                  //       childAspectRatio: 1.5
                  //     ),
                  //     itemBuilder: (BuildContext context, int index) {
                  //       createCellWidget();
                  //     },
                  //    itemCount: 10,
                  // )

                ),
              ),
            ],
          )
    ));
  }


  Widget createCellWidget(){
    return GestureDetector(
      child: Container(
        // height: 40,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(5),
            color: Colors.cyan,
            border: Border.all(color: Colours.c9,width: 2,style: BorderStyle.solid),
          ),
          child: Stack(
            children: [
              Container(
                  color: Colors.white,
                  // height: double.infinity,
                  alignment: Alignment.center,
                  child:SizedBox()

              ),
              Positioned(
                bottom: 0,
                left: 0,
                right: 0,
                child: Container(
                  alignment: Alignment.center,
                  height: 24,
                  width: double.infinity,
                  child: Text('假按揭啊'),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.vertical(bottom:Radius.circular(5)),
                    color:Color(0x20FE250B),
                  ),
                ),
              ),
            ],
          )
      ),
      onTap: (){

      },
    );
  }
}


