part of book_score;



class BookScorePage extends StatefulWidget {
  final String bookId;
  const BookScorePage({
    Key? key,
    required this.bookId
  }) : super(key: key);

  @override
  State<BookScorePage> createState() => _BookScorePageState();
}

class _BookScorePageState extends State<BookScorePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<BookScoreController>(
      init: BookScoreController(widget.bookId),
      builder:(controller) => Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('评分及书评'),
        ),
        body: CustomPullScrollView(
          controller: controller.refreshController,
          onRefresh: controller.onRefresh,
          onLoading: controller.onLoading,
          child: ListView.builder(
              itemBuilder: (BuildContext context, int index){
                return BuildItem(model: controller.scores[index],);
              },
              itemCount: controller.scores.length,
          ),
        ),
      ),
    );
  }
}
