part of user_nick;

class UserNickPage extends StatefulWidget {
  final UserInfoModel userInfo;

  const UserNickPage({Key? key, required this.userInfo}) : super(key: key);

  @override
  State<UserNickPage> createState() => _UserNickPageState();
}

class _UserNickPageState extends State<UserNickPage> {
  TextEditingController _textFieldController = TextEditingController();

  @override
  void initState() {
    super.initState();
    _textFieldController.text = widget.userInfo.name!;
    // 在这里可以使用 localVariable 进行操作
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserNickController>(
        init: UserNickController(widget.userInfo),
        builder: (controller) => Scaffold(
              appBar: CustomAppBar(
                title: const Text('设置昵称'),
                actions: [
                  Container(
                    height: 20,
                    width: 40,
                    decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(10),
                        border: Border.all(color: AppTheme.primary, width: 1)),
                    child: Center(
                      child: GestureDetector(
                          onTap: () {
                            // print("保存昵称");
                            controller._changeInfo(_textFieldController.text);
                          },
                          child: const Text(
                            '保存',
                            style: TextStyle(
                                fontSize: 12, color: AppTheme.primary),
                          )),
                    ),
                  )
                ],
              ),
              body: Container(
                margin: const EdgeInsets.symmetric(horizontal: AppTheme.margin),
                height: 42,
                decoration: BoxDecoration(boxShadow: [
                  BoxShadow(
                    color: Colours.cC7.withOpacity(0.5),
                    spreadRadius: 0,
                    blurRadius: 10,
                    offset: const Offset(3, 0),
                  ),
                ], borderRadius: BorderRadius.circular(8), color: Colors.white),
                child: Container(
                  padding: const EdgeInsets.only(
                    left: 15,
                    right: 15,
                  ),
                  child: Row(
                    children: [
                      const Text(
                        '昵称',
                        style: TextStyle(fontSize: 14, color: Colours.c3),
                      ),
                      Gaps.hGaps15,
                      Expanded(
                        child: TextField(
                          controller: _textFieldController,
                          style:
                              const TextStyle(fontSize: 14, color: Colours.c3),
                          decoration: const InputDecoration(
                              filled: true,
                              fillColor: Colors.transparent,
                              // 设置背景颜色为透明
                              hintText: '请输入昵称',
                              border: InputBorder.none,
                              enabledBorder: InputBorder.none,
                              focusedBorder: InputBorder.none,
                              suffixIconConstraints: BoxConstraints.tightFor(
                                  height: 15, width: 15)),
                        ),
                      ),
                      GestureDetector(
                        onTap: () {
                          // 处理点击事件，可以执行任意操作
                          _textFieldController.clear();
                          print('Image Clicked!');
                        },
                        child: Image(
                          image: AssetImage('assets/images/del.png'),
                          height: 15.w,
                          width: 15.w,
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            ));
  }
}
