part of web;

class ReadCategoryPage extends StatefulWidget {
  final ReadController controller;
  final void Function()? onTap;
  final Function(ChapterModel chapterModel) onTapChapter;
  const ReadCategoryPage({
    Key? key,
    required this.controller,
    required this.onTap,
    required this.onTapChapter
  }) : super(key: key);

  @override
  State<ReadCategoryPage> createState() => _ReadCategoryPageState();
}

class _ReadCategoryPageState extends State<ReadCategoryPage> {

  late TextEditingController searchController = TextEditingController();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      resizeToAvoidBottomInset: false,
      body: Column(
        crossAxisAlignment: CrossAxisAlignment.end,
        children: [
          Container(
              margin: EdgeInsets.only(left: 15.w,right: 15.w,top: 15.w,bottom: 15.w),
              child: GestureDetector(
                  onTap:widget.onTap,
                  child: Image.asset('assets/images/close.png'),
              )
          ),
          Container(
            margin: EdgeInsets.only(left: 15.w,right: 15.w,),
            decoration: BoxDecoration(
              color: const Color(0xFFF9F9F9),
              borderRadius: BorderRadius.circular(17.5.w),
              boxShadow: [
                BoxShadow(
                  color: const Color(0xFFC7C7C7).withOpacity(0.5),
                  offset: Offset(3.w, 0),
                  blurRadius: 10.w,
                  spreadRadius: 0.w,
                ),
              ],
            ),
            child: ClipRRect(
              borderRadius: BorderRadius.circular(17.5.w),
              child: CustomInputSearch(
                controller: searchController,
                readOnly: false,
                hintText: '请输入书籍名称分类',
                onTap: () {
                  // context.pushNamed(Routes.msgs);
                },
                onEditingComplete: () {

                },
              ),
            ),
          ),
          BuildBook(bookDetailModel: widget.controller.bookDetailModel,),
          Expanded(
            child: ListView.builder(
              itemBuilder:(BuildContext context, int index){
                return BuildItem(model: widget.controller.chapters[index],onTapChapter:(ChapterModel chapterModel){
                  widget.onTapChapter(chapterModel);
                  widget.onTap;
                },);
              },
              itemCount: widget.controller.chapters.length,
            ),
          ),
        ],
      ),
    );
  }
}
