part of book_shop;

class BookShopPage extends StatefulWidget {
  const BookShopPage({Key? key}) : super(key: key);

  @override
  State<BookShopPage> createState() => _BookShopPageState();
}

class _BookShopPageState extends State<BookShopPage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('书架'),
      ),
      body: Column(
        children: [
          Expanded(
            child: ListView.builder(
                itemBuilder: (BuildContext context,int index){
                  return const BookCell();
                },
              itemCount: 2,
            ),
          ),
          createCounter()
        ],
      ),
    );
  }

  Widget createCounter() {
    return Container(
      color: Colors.white,
      padding: const EdgeInsets.only(left: 20,right: 15),
      child: Column(
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Row(
                children: [
                  Container(
                    height: 17,
                    width: 17,
                    color: Colors.yellow,
                  ),
                  const SizedBox(width: 11),
                  const Text('全选',style: TextStyle(color: Color(0xFF333333),fontSize: 12,fontWeight: FontWeight.w500)),
                  const SizedBox(width: 15,),
                  const Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text('合计 ￥98.9',style: TextStyle(color: AppTheme.primary,fontSize: 12,fontWeight: FontWeight.w500)),
                      Text('已选 2 件',style: TextStyle(color: Color(0xFF999999),fontSize: 10,))
                    ],
                  )
                ],
              ),
              GestureDetector(
                onTap: (){
                  context.pushNamed(Routes.bookPay);
                },
                child: Container(
                  margin: const EdgeInsets.symmetric(vertical: 9),
                  decoration: BoxDecoration(
                    color: AppTheme.primary,
                    borderRadius: BorderRadius.circular(15),
                  ),
                  padding: const EdgeInsets.symmetric(vertical: 5,horizontal: 18),
                  child: const Text('结算(2)',style: TextStyle(color: Colors.white,fontSize: 12,fontWeight: FontWeight.w500),),
                ),
              )
            ],
          ),
          Container(
            height: 1,
            color: const Color(0xFFF9F9F9),
          )
        ],
      ),
    );
  }
}
