part of login;


class LoginPage extends StatefulWidget {
  const LoginPage({Key? key}) : super(key: key);

  @override
  State<LoginPage> createState() => _LoginPageState();
}

class _LoginPageState extends State<LoginPage> {
  final _formKey = GlobalKey<FormState>();
  bool isChecked = false;
  @override
  Widget build(BuildContext context) {
    return GetBuilder<LoginController>(
        init: LoginController(),
        builder:(controller) => GestureDetector(
          onTap: () => Tools.unfocus(),
          child: Scaffold(
            appBar: CustomAppBar(
              systemOverlayStyle: Theme.of(context).brightness == Brightness.light
                  ? SystemUiOverlayStyle.dark
                  : SystemUiOverlayStyle.light,
              backgroundColor: Colors.transparent,
            ),
            // extendBodyBehindAppBar: true,
            body: SafeArea(
              top: false,
              minimum: const EdgeInsets.all(AppTheme.margin).copyWith(
                // top:Screen.statusBar,
                left: 25,
                right: 25,
                bottom: 25
              ),
              child: Form(
                key: _formKey,
                child: Container(
                  // color: Colors.green,
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Column(
                        // crossAxisAlignment: CrossAxisAlignment.center,
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          const SizedBox(height: 120,),
                          Container(
                            width: 180,
                            height: 50,
                            color: Colors.cyan,
                          ),
                          const SizedBox(height:66),
                          CustomFormInput(
                            // label: 'Phone',
                            // required: true,
                            hintText: '请输入手机号',
                            keyboardType: TextInputType.number,
                            controller: controller.phoneInput,
                            validator: EmailValidator(),
                          ),
                          Gaps.vGaps13,
                          ValueListenableBuilder<bool>(
                            valueListenable: controller.showPassword,
                            builder:(context, value, child) => CustomFormInput(
                              obscureText: !value,
                              hintText: '请输入密码',
                              iconData:
                              value ? Icons.visibility : Icons.visibility_off,
                              controller: controller.passwordInput,
                              validator: EmailValidator(),
                              onIcon: controller.onShowPassword,
                            ),
                          ),
                          Container(
                            margin: const EdgeInsets.only(left: 10,right: 10,top: 8.5),
                            child: const Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Text('验证码登录',style: TextStyle(fontSize: 13,height: 1.3,color: Colours.c6),),
                                Text('忘记密码',style: TextStyle(fontSize: 13,height: 1.3,color: Colours.cBlue),),
                              ],
                            ),
                          ),
                          const SizedBox(height: 30,),
                          // 登录按钮
                          Container(
                            height: 42,
                            width: double.infinity,
                            decoration: BoxDecoration(
                              gradient: const LinearGradient(
                                colors: [Color(0xFFDE2E5E),Color(0xFFC31F4C)],
                                begin: Alignment.centerLeft,
                                end: Alignment.centerRight
                              ),
                              borderRadius: BorderRadius.circular(21),
                            ),
                            child: TextButton(
                              onPressed: () async {
                                FocusScope.of(context).requestFocus(FocusNode());
                                final result = await controller.onLogin(_formKey);
                              },
                              style: TextButton.styleFrom(
                                padding: const EdgeInsets.symmetric(vertical: 10.5),
                                // textStyle: TextStyle(fontSize: 15.0,color: Colors.white),
                              ),
                              child: Text('立即登录',style: TextStyle(color: Colors.white,fontSize: 15.0.w),),
                            ),
                          ),
                        ],
                      ),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          Container(
                            width: 10.w,
                            height: 10.w,
                            color: AppTheme.primary,
                          ),
                          Gaps.hGaps10,
                          const Text('我已阅读并同意',style: TextStyle(color: Colours.c9,fontSize:10)),
                          const Text('《用户协议》',style: TextStyle(color: Colours.cBlue,fontSize:10)),
                          const Text('《隐私政策》',style: TextStyle(color: Colours.cBlue,fontSize:10)),
                        ],
                      )
                    ],
                  ),
                ),
              ),
            )
          ),
        )
    );
  }
}

