part of routes;

abstract class Routes {
  static final RouteObserver<Route> observer = RouteObservers();
  static List<String> history = [];

  static const splash = 'splash';
  static const main = 'main';
  static const ad = 'ad';
  static const login = 'login';
  static const web = 'web';
  static const about = 'about';
  /// 支付界面
  static const bookPay = 'book_pay';
  /// 用户协议 和 隐私政策
  static const terms = 'terms';
  /// 消息
  static const msgs = 'msgs';


  /// 我的
  // 个人信息
  static const userInfo = 'user_info';
  // 修改昵称
  static const nike = 'nike';
  // 性别
  static const gender = 'gender';
  // 设置
  static const set = 'set';
  // 版本
  static const version = 'version';
  // 版本介绍
  static const versionDes = 'version_des';
  // 我的收藏
  static const collect = 'collect';
  // 紫金币
  static const coin = 'coin';


  static final GoRouter config = GoRouter(
      initialLocation: '/$login',
      // initialLocation: '/',
      observers: [observer],
      routes: [
        GoRoute(
            path: '/$splash',
            name: splash,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const SplashPage(),
            ),
        ),
        GoRoute(
            path: '/',
            name: main,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const MainPage()
            )
        ),
        GoRoute(
            path: '/$ad',
            name: ad,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const AdPage()
            )
        ),
        GoRoute(
            path: '/$login',
            name: login,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const LoginPage()
            )
        ),
        GoRoute(
            path: '/$web',
            name: web,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const WebPage()
            )
        ),
        GoRoute(
            path: '/$about',
            name: about,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const AboutPage()
            )
        ),
        GoRoute(
            path: '/$bookPay',
            name: bookPay,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const BookPayPage()
            )
        ),
        GoRoute(
            path: '/$terms',
            name: terms,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const TermsPage()
            )
        ),
        GoRoute(
            path: '/$msgs',
            name: msgs,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const MsgPage()
            )
        ),
        GoRoute(
            path: '/$userInfo',
            name: userInfo,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserInfoPage()
            )
        ),
        GoRoute(
            path: '/$nike',
            name: nike,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserNickPage()
            )
        ),
        GoRoute(
            path: '/$coin',
            name: coin,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserCoinPage()
            )
        )
      ]
  );

}