part of mine;

class MineController extends GetxController {
  // 广告数据
  List<AdModel> ads = [];

  // 个人信息数据
  UserInfoModel userInfo = UserInfoModel();

  // 笔记 讨论 错题 收藏
  List<ReadModel> reads = [];

  // 我的账户数据
  List<ReadModel> accounts = [];

  // 消息未读数
  int num = 0;

  @override
  void onReady() {
    _getAds();
    getNums();
    getInfo();
    super.onReady();
  }

  /// 获取广告数据
  void _getAds() async {
    ads = await CommonAPI.list(type: '4');
    update();
  }

  /// 消息未读数
  void getNums() async {
    num = await CommonAPI.num();
    update();
  }

  /// 获取个人信息数据
  void getInfo() async {
    userInfo = await MineAPI.userInfo();
    reads = [
      ReadModel(
          name: '笔记', value: userInfo.noteNums.toString(), link: Routes.note),
      ReadModel(
          name: '讨论',
          value: userInfo.commentNums.toString(),
          link: Routes.discuss),
      ReadModel(
          name: '错题', value: userInfo.wrongNums.toString(), link: Routes.wrong),
      ReadModel(
          name: '收藏', value: userInfo.collectNums.toString(), link: Routes.love)
    ];
    accounts = [
      ReadModel(
          name: '优惠券',
          value: userInfo.couponNums.toString(),
          link: Routes.coupon,
          icon: 'assets/images/coupon.png'),
      ReadModel(
          name: '积分',
          value: userInfo.integralNums.toString(),
          link: Routes.point,
          icon: 'assets/images/point.png'),
      ReadModel(
          name: '紫金币',
          value: userInfo.beanNums.toString(),
          link: Routes.coin,
          icon: 'assets/images/coin.png'),
      ReadModel(
          name: '订单',
          value: userInfo.ordersNums.toString(),
          link: Routes.order,
          // link: Routes.orderRefunded,
          icon: 'assets/images/order.png')
    ];
    update();
  }
}
