part of study_report;

class StudyReportPage extends StatefulWidget {
  final String bookId;
  const StudyReportPage({
    Key? key,
    required this.bookId
  }) : super(key: key);

  @override
  State<StudyReportPage> createState() => _StudyReportPageState();
}

class _StudyReportPageState extends State<StudyReportPage> {

  @override
  Widget build(BuildContext context) {
    return GetBuilder<StudyReportController>(
      init: StudyReportController(widget.bookId),
      builder:(controller) => Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('学习报告'),
        ),
        body: Container(
          margin: EdgeInsets.only(left: 10.w,top: 10.w,bottom: 10.w,right: 10.w),
          child: SingleChildScrollView(
            child: Column(
              children: [
                BuildCard(model: controller.model,),
                Gaps.vGaps10,
                Row(
                  children: [
                    Expanded(
                      child: Column(
                        children: [
                          Container(
                            padding: EdgeInsets.only(left: 15.w,top: 15.w,bottom: 15.w),
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(8.w),
                              color: Colors.white,
                              boxShadow:  [
                                BoxShadow(
                                  color: Colours.cC7.withOpacity(0.5),
                                  offset: Offset(1, 3.w),
                                  blurRadius: 10.w,
                                  spreadRadius: 0,
                                ),
                              ],
                            ),
                            height: 220.w,
                            child: Column(
                              children: [
                                Row(
                                  children: [
                                    Container(
                                      width: 26.w,
                                      height: 26.w,
                                      // color: Colors.cyan,
                                      child: Image.asset('assets/images/report_note.png',fit: BoxFit.cover,),
                                    ),
                                    Gaps.hGaps10,
                                    Text('笔记',style: TextStyle(fontSize: 18.w,height: 1.3,color: Colours.c3,fontWeight: Fonts.boldSemi),)

                                  ],
                                ),
                                Expanded(
                                  child: Column(
                                    mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                                    children: [
                                      _buildItem(title: '划线', num: controller.model.lineNums.toString()),
                                      _buildItem(title: '高亮', num: controller.model.colorNums.toString()),
                                      _buildItem(title: '笔记', num: controller.model.noteNums.toString()),

                                    ],
                                  ),
                                )
                              ],
                            ),
                          ),
                          Gaps.vGaps10,
                          Container(
                            padding: EdgeInsets.only(left: 15.w,top: 15.w,bottom: 15.w),
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(8.w),
                              color: Colors.white,
                              boxShadow:  [
                                BoxShadow(
                                  color: Colours.cC7.withOpacity(0.5),
                                  offset: Offset(1, 3.w),
                                  blurRadius: 10.w,
                                  spreadRadius: 0,
                                ),
                              ],
                            ),
                            height: 110.w,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Row(
                                  children: [
                                    Container(
                                      width: 26.w,
                                      height: 26.w,
                                      child: Image.asset('assets/images/report_study.png',fit: BoxFit.cover,)
                                      // color: Colors.cyan,
                                    ),
                                    Gaps.hGaps10,
                                    Text('距离连续学习',style: TextStyle(fontSize: 18.w,height: 1.3,color: Colours.c3,fontWeight: Fonts.boldSemi),)

                                  ],
                                ),
                                Gaps.vGaps5,
                                RichText(text: TextSpan(
                                    children: [
                                      TextSpan(text: controller.model.maxSecond!=null?controller.model.maxSecond.toString():'',style: TextStyle(fontSize: 21.w,height: 1.5,color: Colours.c3,fontWeight: Fonts.medium)),
                                      TextSpan(text: '分钟',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c3)),
                                    ]
                                ))
                              ],
                            ),
                          )
                        ],
                      ),
                    ),
                    Gaps.hGaps10,
                    Expanded(
                      child: Container(// color: Colors.limeAccent,
                        child: Column(
                          children: [
                            Container(
                              padding: EdgeInsets.only(left: 15.w,top: 15.w,bottom: 15.w,right: 30),
                              height: 172,
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(8.w),
                                color: Colors.white,
                                boxShadow:  [
                                  BoxShadow(
                                    color: Colours.cC7.withOpacity(0.5),
                                    offset:  Offset(1, 3.w),
                                    blurRadius: 10.w,
                                    spreadRadius: 0,
                                  ),
                                ],
                              ),
                              child: Column(
                                children: [
                                  Row(
                                    children: [
                                      Container(
                                        width: 26.w,
                                        height: 26.w,
                                        child: Image.asset('assets/images/report_test.png',fit: BoxFit.cover,)
                                        // color: Colors.cyan,
                                      ),
                                      Gaps.hGaps10,
                                      Text('知识测评',style: TextStyle(fontSize: 18.w,height: 1.3,color: Colours.c3,fontWeight: Fonts.boldSemi),)

                                    ],
                                  ),
                                  Expanded(
                                      child: Column(
                                        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                                        children: [
                                          Row(
                                            // mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                            children: [
                                              RichText(text: TextSpan(
                                                  children: [
                                                    TextSpan(text: '总回顾',style: TextStyle(fontSize: 14.w,height: 1.5,color: Colours.c9),),
                                                    WidgetSpan(child: SizedBox(width: 36.w),),
                                                    TextSpan(text:controller.model.questionAllNums !=null? controller.model.questionAllNums.toString():'' ,style: TextStyle(fontSize: 21.w,height: 1.5,color: Colours.c3,fontWeight: Fonts.medium)),
                                                    TextSpan(text: '/条',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c3)),
                                                  ]
                                              ))
                                            ],
                                          ),
                                          Row(
                                            // mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                            children: [
                                              RichText(text: TextSpan(
                                                  children: [
                                                    TextSpan(text: '评论正确率',style: TextStyle(fontSize: 14.w,height: 1.5,color: Colours.c9),),
                                                    WidgetSpan(child: SizedBox(width: 8.w),),
                                                    TextSpan(text:controller.model.questionAccuracy!=null?controller.model.questionAccuracy.toString():'' ,style: TextStyle(fontSize: 21.w,height: 1.5,color: Colours.c3,fontWeight: Fonts.medium)),
                                                    TextSpan(text: '%',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c3)),
                                                  ]
                                              ))
                                            ],
                                          ),
                                        ],
                                      )
                                  )
                                ],
                              ),
                            ),
                            Gaps.vGaps10,
                            Container(
                              padding: EdgeInsets.only(left: 15.w,top: 15.w,bottom: 15.w),
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(8.w),
                                color: Colors.white,
                                boxShadow:  [
                                  BoxShadow(
                                    color: Colours.cC7.withOpacity(0.5),
                                    offset: Offset(1, 3.w),
                                    blurRadius: 10.w,
                                    spreadRadius: 0,
                                  ),
                                ],
                              ),
                              height: 172.w,
                              child: Column(
                                children: [
                                  Row(
                                    children: [
                                      Container(
                                        width: 26.w,
                                        height: 26.w,
                                        // color: Colors.cyan,
                                        child: Image.asset('assets/images/report_discuss.png',fit: BoxFit.cover,)
                                      ),
                                      Gaps.hGaps10,
                                      Text('讨论',style: TextStyle(fontSize: 18.w,height: 1.3,color: Colours.c3,fontWeight: Fonts.boldSemi),)

                                    ],
                                  ),
                                  Expanded(
                                    child: Column(
                                      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                                      children: [
                                        _buildItem(title: '发起讨论', num: controller.model.commentPostNums.toString()),
                                        _buildItem(title: '参与讨论', num: controller.model.commentReplyNums.toString())
                                      ],
                                    ),
                                  )
                                ],
                              ),
                            )
                          ],
                        ),
                      ),
                    )
                  ]
                )
              ],
            ),
          ),
        ),
      ),
    );
  }

 Widget _buildItem({
    required String title,
    required String num
  }){
    return Row(
      children: [
        RichText(text: TextSpan(
            children: [
              TextSpan(text: title,style: TextStyle(fontSize: 14.w,height: 1.5,color: Colours.c9)),
              WidgetSpan(child: SizedBox(width: 8.w),),
              TextSpan(text: num=='null'?'':num,style: TextStyle(fontSize: 21.w,height: 1.5,color: Colours.c3,fontWeight: Fonts.medium)),
              TextSpan(text: '/条',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c3)),
            ]
        ))
      ],
    );
 }


}
