part of apis;

abstract class ShopAPI {

  /// 1、加入书架
  ///
  static Future <bool> addCart({
    required String  bookId,
  }) async {
    final result = await HttpService.to.post(
      '/v1/orders/Orders/addCart',
      params: {
        'book_id':bookId,
      },
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 2、删除书架
  ///
  static Future <bool> delCart({
    required String cartId,
  }) async {
    final result = await HttpService.to.post(
      '/v1/orders/Orders/delCart',
      params: {
        'cart_id':cartId,
      },
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 3、书架列表
  static Future <List<CourseModel>> cart({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/orders/Orders/getCartListAll',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }



}