part of login;


class LoginPage extends StatefulWidget {
  const LoginPage({Key? key}) : super(key: key);

  @override
  State<LoginPage> createState() => _LoginPageState();
}

class _LoginPageState extends State<LoginPage> {
  final _formKey = GlobalKey<FormState>();
  bool isChecked = false;


  @override
  Widget build(BuildContext context) {
    return GetBuilder<LoginController>(
        init: LoginController(),
        builder:(controller) => GestureDetector(
          onTap: () => Tools.unfocus(),
          child: Scaffold(
            resizeToAvoidBottomInset: false,
            appBar: CustomAppBar(
              systemOverlayStyle: Theme.of(context).brightness == Brightness.light
                  ? SystemUiOverlayStyle.dark
                  : SystemUiOverlayStyle.light,
              backgroundColor: Colors.transparent,
            ),
            body: Container(
              color: Colors.white,
              child: Stack(
                  children: [
                    Image.asset(
                      'assets/images/login_bg.png',
                      fit: BoxFit.contain,
                      width: double.infinity,
                    ),
                    SafeArea(
                      top: false,
                      minimum: EdgeInsets.all(AppTheme.margin).copyWith(
                        // top:Screen.statusBar,
                          left: 25.w,
                          right: 25.w,
                          bottom: 25.w
                      ),
                      child: Column(
                        children: [
                          Expanded(
                            child: SingleChildScrollView(
                              child: Form(
                                autovalidateMode: AutovalidateMode.always,
                                onChanged: (){
                                  setState(() {
                                    print('++++++++++++++++');
                                  });
                                },
                                key: _formKey,
                                child: Column(
                                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                  children: [
                                    Column(
                                      // crossAxisAlignment: CrossAxisAlignment.center,
                                      mainAxisAlignment: MainAxisAlignment.center,
                                      children: [
                                        SizedBox(height: 120.w,),
                                        Container(
                                          width: 180.w,
                                          height: 50.w,
                                          // color: Colors.cyan,
                                          child: Image.asset(
                                            'assets/images/zijing_icon.png',
                                          ),
                                        ),
                                        SizedBox(height:66.w),
                                        //
                                        CustomFormInput(
                                          // label: 'Phone',
                                          // required: true,
                                          hintText: '请输入手机号',
                                          keyboardType: TextInputType.number,
                                          controller: controller.phoneInput,
                                          onChanged: (text){
                                            controller.setCanClick();
                                          },
                                        ),
                                        Gaps.vGaps13,
                                        (controller.loginType == 0)?
                                        ValueListenableBuilder<bool>(
                                          valueListenable: controller.showPassword,
                                          builder:(context, value, child) => CustomFormInput(
                                            obscureText: !value,
                                            hintText: '请输入密码',
                                            iconData:
                                            value ? Image.asset(
                                              'assets/images/eye_open.png',
                                            )  : Image.asset(
                                              'assets/images/eye_close.png',
                                            ),
                                            controller: controller.passwordInput,
                                            onChanged: (text){
                                              controller.setCanClick();
                                            },
                                            onIcon: controller.onShowPassword,
                                          ),
                                        ):Stack(
                                          alignment: Alignment.centerRight,
                                          children: [
                                            CustomFormInput(
                                              // label: 'Phone',
                                              // required: true,
                                              hintText: '请输入验证码',
                                              keyboardType: TextInputType.number,
                                              controller: controller.codeInput,
                                            ),
                                            Positioned(
                                                right: 10.w,
                                                child: Row(
                                                  children: [
                                                    Container(height: 20.w,width: 1,color: const Color(0xFFEBEBEB),),
                                                    Gaps.hGaps10,
                                                    GestureDetector(
                                                      child: Container(
                                                          padding: EdgeInsets.symmetric(vertical: 10.w),
                                                          // color: Colors.yellow,
                                                          child: Text(controller.isCounting?'${controller.countDown}':'获取验证码',style: TextStyle(fontSize: 11.w,color: AppTheme.primary,height: 1.4),)),
                                                      onTap: (){
                                                        if (controller.isCounting == false){
                                                          controller.sendCode();
                                                        }
                                                      },
                                                    ),
                                                  ],
                                                )
                                            )
                                          ],
                                        ),
                                        Container(
                                            margin: EdgeInsets.only(left: 10.w,right: 10.w,top: 8.5.w),
                                            alignment: Alignment.centerLeft,
                                            child: Row(
                                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                              children: [
                                                controller.loginType == 0? GestureDetector(
                                                  child: Text('验证码登录',style: TextStyle(fontSize: 13.w,height: 1.3,color: Colours.c6),),
                                                  onTap: (){
                                                    controller.updateLoginType(1);
                                                  },
                                                ):GestureDetector(
                                                  child: Text('密码登录',style: TextStyle(fontSize: 13.w,height: 1.3,color: Colours.c6),),
                                                  onTap: (){
                                                    controller.updateLoginType(0);
                                                  },
                                                ),
                                                controller.loginType == 0? GestureDetector(
                                                  child: Text('忘记密码',style: TextStyle(fontSize: 13.w,height: 1.3,color: Colours.cBlue),),
                                                  onTap: (){
                                                    context.pushNamed(Routes.forgetPwd);
                                                  },
                                                ): Text('*登录后将自动完成注册',style: TextStyle(fontSize: 13.w,height: 1.3,color: Colours.c6),),
                                              ],
                                            )
                                        ),
                                        SizedBox(height: 30.w,),
                                        CustomGradientButton(
                                          text: '立即登录',
                                          isEnabled: controller.enable,
                                          onPressed: () {
                                            print('11111111111111111');
                                            controller.onLogin(context);
                                          },
                                        )
                                      ],
                                    ),

                                  ],
                                ),
                              ),
                            ),
                          ),
                          Row(
                            mainAxisAlignment: MainAxisAlignment.center,
                            crossAxisAlignment: CrossAxisAlignment.center,
                            children: [
                              GestureDetector(
                                onTap: (){
                                  ///TODO: 同意协议
                                  controller.setAgree();
                                },
                                child: Row(
                                  children: [
                                    SizedBox(
                                      width: 10.w,
                                      height: 10.w,
                                      // color: AppTheme.primary,
                                      child: Image.asset(
                                        controller.agree?'assets/images/check_box_select.png':'assets/images/uncheck.png',
                                      ),
                                    ),
                                    Gaps.hGaps5,
                                    Text('我已阅读并同意',style: TextStyle(color: Colours.c9,fontSize:10.w)),
                                  ],
                                ),
                              ),
                              GestureDetector(
                                child: Text('《用户协议》',style: TextStyle(color: Colours.cBlue,fontSize:10.w)),
                                onTap: (){
                                  context.pushNamed(Routes.terms);
                                },
                              ),
                              GestureDetector(
                                child: Text('《隐私政策》',style: TextStyle(color: Colours.cBlue,fontSize:10.w)),
                                onTap: (){
                                  context.pushNamed(Routes.terms);
                                },
                              ),
                            ],
                          )
                        ],
                      ),
                    ),
                  ],
                ),
            ),
          )
          ),
        );
  }
}

