part of user_discuss;

class UserDiscussPage extends StatefulWidget {
  const UserDiscussPage({Key? key}) : super(key: key);

  @override
  State<UserDiscussPage> createState() => _UserDiscussPageState();
}

class _UserDiscussPageState extends State<UserDiscussPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserDiscussController>(
      init: UserDiscussController(),
      builder:(controller)=> Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('讨论'),
        ),
        body: Container(
          color: Colors.transparent,
          child: CustomPullScrollView(
            controller: controller.refreshController,
            // onRefresh: controller.onRefresh,
            onLoading: controller.onLoading,
            child:SingleChildScrollView(
              child: Container(
                margin: EdgeInsets.all(10.w),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(8.w),
                  color: Colors.white,
                  boxShadow: [
                    BoxShadow(
                      color: const Color(0xFFC7C7C7).withOpacity(0.5),
                      offset: Offset(3.w, 0),
                      blurRadius: 10.w,
                      spreadRadius: 0.w,
                    ),
                  ],
                ),
                child: ListView.builder(
                  physics: const NeverScrollableScrollPhysics(),
                  shrinkWrap: true,
                  itemBuilder: (BuildContext context, int index){
                    return GestureDetector(
                      onTap: (){
                        context.pushNamed(Routes.discussDes,extra: controller.discuss[index]);
                      },
                        child: BuildItem(model: controller.discuss[index],index: index,num: controller.discuss.length,)
                    );
                  },
                  itemCount: controller.discuss.length,
                ),
              ),
            )
          ),
        ),
      ),
    );
  }
}
