part of utils;

abstract class Access {

  /// 图片权限
  static Future<bool> photos() async {
    if (Platform.isIOS) {
      final result = await [Permission.photos].request();
      return result[Permission.photos] == PermissionStatus.granted ||
          result[Permission.photos] == PermissionStatus.limited;
    }
    if (Platform.isAndroid) {
      final result = await [Permission.storage].request();
      return result[Permission.storage] == PermissionStatus.granted;
    }
    return false;
  }

  /// 打开设置
  static Future<void> setting() async => await openAppSettings();

  /// 存储权限
  static Future<bool> storage() async {
    final result = await [Permission.storage].request();
    return result[Permission.storage] == PermissionStatus.granted;
  }

}
