part of user_discuss_des;

class BuildListPage extends StatefulWidget {
  final String tag;
  final CourseModel model;
  const BuildListPage({
    Key? key,
    required this.tag,
    required this.model
  }) : super(key: key);


  @override
  State<BuildListPage> createState() => _BuildListPageState();
}

class _BuildListPageState extends State<BuildListPage> with AutomaticKeepAliveClientMixin{
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserDiscussDesController>(
      tag: widget.tag,
      init: UserDiscussDesController(widget.tag,widget.model),
      builder: (controller) =>CustomPullScrollView(
        controller: controller.refreshController,
        onRefresh: controller.onRefresh,
        onLoading: controller.onLoading,
        child: ListView.builder(
            itemBuilder: (BuildContext context,int index){
              DiscussModel model = controller.discuss[index];
              return BuildDiscuss(
                model: model,
                bookId: widget.model.bookId.toString(),
              );
            },
          itemCount: controller.discuss.length,
        ),
      ),
    );
  }

  @override
  bool get wantKeepAlive => true;
}
