import 'package:flutter/cupertino.dart';
import 'package:flutter/services.dart';
import 'package:flutter_book/services/index.dart';
import 'package:flutter_book/store/index.dart';
import 'package:get/get.dart';
class Global {
  static Future<void> init() async {
    // 确保 Flutter 绑定已经初始化
    WidgetsFlutterBinding.ensureInitialized();
    // 设置应用程序的首选屏幕方向
    await SystemChrome.setPreferredOrientations([DeviceOrientation.portraitUp]);

    await Future.wait([
      // 配置存储
      Get.putAsync<StorageService>(() => StorageService().init()),
    ]).whenComplete(() {

      print('初始化****************');
      // 网络
      Get.put<HttpService>(HttpService());
      //配置基本设置
      Get.put<ConfigStore>(ConfigStore());
      //
      Get.put<UserStore>(UserStore());

    });
  }
}