part of help_center;


class HelpCenterPage extends StatefulWidget {
  const HelpCenterPage({Key? key}) : super(key: key);

  @override
  State<HelpCenterPage> createState() => _HelpCenterPageState();
}

class _HelpCenterPageState extends State<HelpCenterPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<HelpCenterController>(
        init: HelpCenterController(),
        builder: (controller) => Scaffold(
          appBar: AppBar(
            centerTitle: true,
            title: const Text('帮助中心'),
          ),
          body: CustomPullScrollView(
            controller: controller.refreshController,
            onRefresh: controller.onRefresh,
            onLoading: controller.onLoading,
            child: SingleChildScrollView(
              child: Container(
                margin: EdgeInsets.all(10.w),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(8.w),
                  color: Colors.white,
                  boxShadow: [
                    BoxShadow(
                      color: const Color(0xFFC7C7C7).withOpacity(0.5),
                      offset: Offset(3.w, 0),
                      blurRadius: 10.w,
                      spreadRadius: 0.w,
                    ),
                  ],
                ),
                child: ClipRRect(
                  borderRadius: BorderRadius.circular(8.w),
                  child: ListView.builder(
                    shrinkWrap: true,
                    physics: const NeverScrollableScrollPhysics(),
                    itemCount: controller.helpCenters.length,
                    itemBuilder: (BuildContext context, int index){
                      HelpCenterModel model = controller.helpCenters[index];
                      return GestureDetector(
                        child: BuildItem(model: model,),
                        onTap: (){
                          context.pushNamed(Routes.helpCenterContent,queryParameters: {'id': model.id.toString()});
                        },

                      );
                    }),
                ),
              ),
            ),
          ),
        ));
  }
}
