part of user_discuss_des;

class BuildDiscuss extends StatelessWidget {
  final DiscussModel model;
  const BuildDiscuss({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(left: 10.w,right: 10.w,top: 10.w),
      padding:  EdgeInsets.all(10.w),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(4.w),
        color: Colors.white,
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: Offset(1.5.w, 0),
            blurRadius: 7.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          RichText(text: TextSpan(
            children: [
              TextSpan(text: '话题：',style: TextStyle(
                  fontSize: 14.w,
                  height: 1.5.w,
                  color: Colours.c3,
              )),
              TextSpan(text: model.title,style: TextStyle(
                  fontSize: 14.w,
                  height: 1.5.w,
                  color: Colours.c3,
                  fontWeight: Fonts.medium
              )),
            ]
          )),
          Gaps.vGaps10,
          Container(
            height: 0.5.w,
            color: Colours.cF2,
          ),
          _buildItem(model),
          Container(
            margin:EdgeInsets.only(left: 15.w),
              child: _buildListView(model.commentAll != null ? model.commentAll!:[])
          ),
          Gaps.vGaps13,
          Container(
            width: double.infinity,
            padding: EdgeInsets.symmetric(vertical: 5.w,horizontal: 10.w),
            color: Colours.cF8,
            child:Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(model.chapterName??'',style:  TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),),
                Text('内容：${model.quoteContent??''}',style: TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),),
              ],
            )
          )
        ],
      ),
    );
  }


  Widget _buildItem(DiscussModel model,{int type =0}){
    return Row(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
          margin: EdgeInsets.only(top: 10.w),
          child: ClipRRect(
            borderRadius: BorderRadius.circular(17.5.w),
            child: Container(
              width: 35.w,
              height: 35.w,
              color: Colors.red,
              child: CustomImage.network(url: model.personPic??''),
            ),
          ),
        ),
        Expanded(
          child: Container(
            margin: EdgeInsets.only(left: 10.w,top: 10.w),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Row(
                      children: [
                        Text(model.personName??'',style: TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),),
                        Gaps.hGaps10,
                        type ==1?const SizedBox(): Text('发起人',style: TextStyle(fontSize: 11.w,height: 1.5,color: AppTheme.primary),)
                      ],
                    ),
                    Text(model.createTime??'',style:  TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),)
                  ],
                ),
                type ==0? Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(model.content?.text?.content??'',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c3),),
                    Gaps.vGaps10,
                    _buildImageGridView()
                  ],
                )
                :RichText(text: TextSpan(
                  children: [
                    TextSpan(text: '回复 ',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c3)),
                    TextSpan(text: model.replacePersonName??'',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c9)),
                    TextSpan(text: '：${model.content?.text?.content??''}',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c3)),
                  ]
                )),
                Row(
                  children: [
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        SizedBox(
                          height: 15.w,
                          width: 15.w,
                          // color: Colors.green,
                          child: Image.asset('assets/images/love.png'),
                        ),
                        Text(model.goodNum.toString(),style: TextStyle(fontSize:12.w,height: 1.5,color: Colours.c9))
                      ],
                    ),
                    Gaps.hGaps15,
                    Row(
                      children: [
                        SizedBox(
                          height: 15.w,
                          width: 15.w,
                          // color: Colors.yellow,
                          child: Image.asset('assets/images/discuss_big.png'),
                        ),
                        Text(model.replyNum.toString(),style: TextStyle(fontSize:12.w,height: 1.5,color: Colours.c9))
                      ],
                    )
                  ],
                )
              ],
            ),
          ),
        )
      ],
    );
  }

  Widget _buildListView(List<DiscussModel> data){
    return ListView.builder(
      physics: const NeverScrollableScrollPhysics(),
      shrinkWrap: true,
      itemBuilder: (BuildContext context,int index){
        return _buildItem(data[index],type: 1);
      },
      itemCount: data.length,
    );
  }


  // 图片
  Widget _buildImageGridView(){
    return GridView.builder(
      // padding: const EdgeInsets.only(left: 13,top: 10),
      physics: const NeverScrollableScrollPhysics(),
      shrinkWrap: true,
      gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
          crossAxisCount: 6,
          crossAxisSpacing: 2.w,
          mainAxisSpacing: 2.w,
          childAspectRatio: 1
      ),
      itemBuilder: (BuildContext context, int index) {
        MediaModel? mediaModel = model.content?.image?[index];
        return CustomImage.network(url: model?.content?.image?[index].content??'',fit: BoxFit.cover,);
        // return Container(
        //   color: Colors.red,
        // );
      },
      itemCount: model.content?.image?.length,
      // itemCount: 2,
    );
  }

  // Widget _buildAudioListView(){
  //   return ListView.builder(
  //     physics: const NeverScrollableScrollPhysics(),
  //     shrinkWrap: true,
  //     itemBuilder: (BuildContext context, int index) {
  //       MediaModel mediaModel = model.noteContent!.audio![index];
  //       return Container(
  //         height: 20.w,
  //         margin: EdgeInsets.only(right: 130.w),
  //         child: Container(
  //           margin: EdgeInsets.only(top: 5.w),
  //           padding: EdgeInsets.only(right:20.w,left: 10.w),
  //           decoration: BoxDecoration(
  //             borderRadius: BorderRadius.circular(10.w),
  //             color: Colours.cF9,
  //           ),
  //           child: Row(
  //             // mainAxisSize: MainAxisSize.min,
  //             mainAxisAlignment:MainAxisAlignment.spaceBetween,
  //             children: [
  //               GestureDetector(
  //                   onTap: (){
  //                     if (onTapAudio !=null) onTapAudio!(mediaModel);
  //                   },
  //                   child: Image.asset('assets/images/audio.png')
  //               ),
  //               Text('0:00/${mediaModel.duration}',style: TextStyle(fontSize: 10.w,height: 1.4,color: Colours.c9),)
  //             ],
  //           ),
  //         ),
  //       );
  //     },
  //     itemCount: model.noteContent?.audio?.length,
  //   );
  // }
}


