part of user_order_evaluate;

/// 用户订单评价
class UserOrderEvaluatePage extends StatefulWidget {

  final String orderNum; // 订单号
  final OrderInfoModel orderInfoModel; // 订单详情
  const UserOrderEvaluatePage({
    Key? key,
    required this.orderNum,
    required this.orderInfoModel,
  }) : super(key: key);

  @override
  State<UserOrderEvaluatePage> createState() => _UserOrderEvaluatePageState();
}

class _UserOrderEvaluatePageState extends State<UserOrderEvaluatePage> with AutomaticKeepAliveClientMixin{
  late UserOrderEvaluateController myController;
  List<TextEditingController> controllers = [];
  List<OrderEvaluate> orderEvaluates = [];
  List<double> ratings = [];
  @override
  void initState() {
      myController = Get.put(UserOrderEvaluateController(widget.orderNum,widget.orderInfoModel));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder(future: myController.getOrderInfo(),
    builder: (context, snapshot) {
      if (snapshot.connectionState == ConnectionState.waiting) {
        return Scaffold(
            appBar: AppBar(
            centerTitle: true,
            title: const Text('订单评价'),
      ),);
      }else{
        return  Scaffold(
          appBar: AppBar(
            centerTitle: true,
            title: const Text('订单评价'),
          ),
          body: Column(
            children: [
              Expanded(
                child: SingleChildScrollView(
                  child: Column(
                    children: [
                      ListView.builder(
                        physics: const NeverScrollableScrollPhysics(),
                        shrinkWrap: true,
                        itemBuilder: (BuildContext context, int index) {
                          return listItem(
                              myController.orderInfoModel.bookList![index],
                              orderEvaluates,controllers);
                        },
                        itemCount:
                        myController.orderInfoModel.bookList?.length,
                      ),
                    ],
                  ),
                ),
              ),
              SizedBox(
                height: 26.w,
              ),
              Container(
                margin: EdgeInsets.symmetric(horizontal: 10.w),
                child: CustomGradientButton(
                  text: '提交评价',
                  isEnabled: myController.enable,
                  onPressed: () {
                    for(int i=0;i<orderEvaluates.length;i++){
                      orderEvaluates[i].comments=controllers[i].text.toString();
                    }
                    print(jsonEncode(orderEvaluates));
                    myController.UpOrderEvaluate(jsonEncode(orderEvaluates));
                  },
                ),
              ),
              SizedBox(
                height: 41.w,
              )
            ],
          ),
        );

        /*GetBuilder<UserOrderEvaluateController>(
            init:
            UserOrderEvaluateController(widget.orderNum, widget.orderInfoModel),
            builder: (controller) => Scaffold(
              appBar: AppBar(
                centerTitle: true,
                title: const Text('订单评价'),
              ),
              body: Column(
                children: [
                  Expanded(
                    child: SingleChildScrollView(
                      child: Column(
                        children: [
                          ListView.builder(
                            physics: const NeverScrollableScrollPhysics(),
                            shrinkWrap: true,
                            itemBuilder: (BuildContext context, int index) {
                              return listItem(
                                  controller.orderInfoModel.bookList![index],
                                  orderEvaluates,controllers,myController);
                            },
                            itemCount:
                            controller.orderInfoModel.bookList?.length,
                          ),
                        ],
                      ),
                    ),
                  ),
                  SizedBox(
                    height: 26.w,
                  ),
                  Container(
                    margin: EdgeInsets.symmetric(horizontal: 10.w),
                    child: CustomGradientButton(
                      text: '提交评价',
                      isEnabled: controller.enable,
                      onPressed: () {
                        for(int i=0;i<orderEvaluates.length;i++){
                          orderEvaluates[i].comments=controllers[i].text.toString();
                        }
                        print(jsonEncode(orderEvaluates));
                        controller.UpOrderEvaluate(jsonEncode(orderEvaluates));
                      },
                    ),
                  ),
                  SizedBox(
                    height: 41.w,
                  )
                ],
              ),
            ));*/
      }
    },);


  }

  Widget listItem(BookListModel bookListModel,
      List<OrderEvaluate> orderEvaluates,
      List<TextEditingController> controllers) {
    int indexToUpdate = orderEvaluates.indexWhere((obj) => obj.recordId == bookListModel.recordId);
    TextEditingController textFieldController= TextEditingController();
    if(indexToUpdate==-1){
      OrderEvaluate evaluate = OrderEvaluate(recordId: bookListModel.recordId);
      orderEvaluates.add(evaluate);
      controllers.add(textFieldController);

    }else{
      textFieldController = controllers[indexToUpdate];
    }
    int index = orderEvaluates.length-1;

    return Container(
      margin:
          EdgeInsets.only(left: 10.w, top: 10.w, right: 10.w),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8.w),
        color: const Color(0xFFF9F9F9),
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: Offset(3.w, 0),
            blurRadius: 7.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      child: ClipRRect(
        borderRadius: BorderRadius.circular(8.w),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            // 图书容器
            Container(
              color: Colours.cF8,
              padding: EdgeInsets.symmetric(horizontal: 11.w, vertical: 12.w),
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Container(
                    padding: EdgeInsets.all(2.w),
                    height: 88.w,
                    width: 73,
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(4.w),
                      color: Colors.white,
                      boxShadow: [
                        BoxShadow(
                          color: const Color(0xFF707070).withOpacity(0.5),
                          offset: const Offset(0, 0),
                          blurRadius: 4.5.w,
                          spreadRadius: 0.w,
                        ),
                      ],
                    ),
                    child: Image.network(
                      // 'http://zxts-book-file.zijingebook.com/2024-01/29/b91194564969b9151fa382807977282acdffa22d.jpg',
                      bookListModel.img.toString(),
                      // 用实际图片链接替换
                      fit: BoxFit.cover,
                    ),
                  ),
                  Gaps.hGaps10,
                  Expanded(
                    child: Text(
                      bookListModel.name.toString(),
                      style: TextStyle(
                          fontSize: 13.w,
                          height: 1.5,
                          fontWeight: Fonts.medium,
                          color: Colours.c3),
                      maxLines: 2,
                      overflow: TextOverflow.ellipsis,
                    ),
                  ),
                ],
              ),
            ),
            // 评价容器
            Container(
              padding: EdgeInsets.only(
                top: 1.w,
              ),
              width: double.infinity,
              height: 160.w,
              color: Colors.white,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      Container(
                        padding: EdgeInsets.only(left: 10.w),
                        child: const Text('评分'),
                      ),
                      Gaps.hGaps20,
                      AbsorbPointer(
                        absorbing: false,
                        child: CustomRating(
                          max: 5,
                          score: 0,
                          star: Star(
                            fat: 0.5,
                            progress: 7,
                            fillColor: AppTheme.primary,
                            size: 16.w,
                            emptyColor: Colours.cE2,
                          ),
                          onRating: (double) {
                            orderEvaluates[index].rating=double;
                            myController.setCanClick(double);
                            print(double);
                          },
                        ),
                      ),
                    ],
                  ),
                  Expanded(
                    // color: Colors.red,
                    child: CustomInput(
                      decoration: InputDecoration(
                          focusedBorder: InputBorder.none,
                          border: InputBorder.none,
                          enabledBorder: InputBorder.none,
                          errorBorder: InputBorder.none,
                          fillColor: Colors.white,
                          hintStyle: TextStyle(
                              fontSize: 14.w, height: 1.5, color: Colours.c6)),
                      maxLines: 5,
                      controller: textFieldController,
                      hintText: '请简要描述',
                    ),
                  ),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

  @override
  bool get wantKeepAlive => true;
}
