part of book_detail;



class BookDetailPage extends StatefulWidget {
  const BookDetailPage({Key? key}) : super(key: key);

  @override
  State<BookDetailPage> createState() => _BookDetailPageState();
}

class _BookDetailPageState extends State<BookDetailPage> with SingleTickerProviderStateMixin{


  @override
  Widget build(BuildContext context) {
    return GetBuilder<BookDetailController>(
      init:BookDetailController(),
      builder: (controller)=> Scaffold(
        appBar:  CustomAppBar(
          backgroundColor: const Color(0xFFAB1941).withOpacity(0.02),
          title: const Text('详情'),
          actions: [
            CustomButton.icon(
              padding: EdgeInsets.zero,
              backgroundColor: Colors.transparent,
              icon: const Icon(Ionicons.timer),
              onPressed: () => context.pushNamed(Routes.msgs),
            ),
            CustomButton.icon(
              padding: EdgeInsets.zero,
              backgroundColor: Colors.transparent,
              icon: const Icon(Ionicons.timer),
              onPressed: () => context.pushNamed(Routes.msgs),
            ),
          ],
        ),
        body:
        Column(
          children: [
            const BuildBook(),
            Container(
              height: 10,
              color: const Color(0xFFF9F9F9),
            ),
            const BuildStudy(),
            Container(
              height: 2,
              color: const Color(0xFFF9F9F9),
            ),
            TabBar(
              labelColor: AppTheme.primary,
              // isScrollable: true,
              labelStyle: const TextStyle(fontSize: 15,height: 1.4,fontWeight: Fonts.medium),
              unselectedLabelColor: Colours.c9,
              unselectedLabelStyle: const TextStyle(fontSize: 15,height: 1.4),
              indicatorSize: TabBarIndicatorSize.label,
              indicatorColor: AppTheme.primary,
              tabs:controller.tabs,
              physics: const NeverScrollableScrollPhysics(),
              controller: controller.tabController,
            ),
            Expanded(
              child: TabBarView(
                controller: controller.tabController,
                children: [
                  BookCategoryPage(),
                  Container(
                    color: Colors.lightBlue,
                  ),
                  BookInfoPage()
                ],
              ),
            ),

          ],
        ),
        bottomNavigationBar: SafeArea(
          child: Container(
            margin: EdgeInsets.symmetric(horizontal: 15),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
              children: [
                Expanded(
                  child: GestureDetector(
                    onTap: (){
                      context.pushNamed(Routes.studyReport);
                    },
                    child: Container(
                      alignment: Alignment.center,
                      height: 35,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(17.5),
                        border:Border.all(
                          width: 0.5,
                          color: Colours.c9
                        ),
                        // color: Colours.cE0.withOpacity(0.5),
                      ),
                      // padding: EdgeInsets.symmetric(vertical: 8),
                      child: const Text('学习报告',style: TextStyle(fontSize: 13,color: Colours.c9,height: 1.5),),
                    ),
                  ),
                ),
                Gaps.hGaps10,
                Expanded(
                  child: GestureDetector(
                    onTap: (){
                      context.pushNamed(Routes.creditPoints).then((value){
                        print('---------------------$value');
                      });
                    },
                    child: Container(
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(17.5),
                        color: AppTheme.primary.withOpacity(0.1)
                      ),
                      height: 35,
                      alignment: Alignment.center,
                      padding: EdgeInsets.symmetric(vertical: 8),
                      child: Text('阅读',style: TextStyle(fontSize: 13,color: AppTheme.primary,height: 1.5),),
                    ),
                  ),
                )
              ],
            ),
          ),
        ),
      ),
    );

  }



  Widget test(){
    return NestedScrollView(
        headerSliverBuilder: (BuildContext context ,bool innerBoxIsScrolled){
          return [
            SliverList(
                delegate: SliverChildListDelegate([
                  const BuildBook(),
                  Container(
                    height: 10,
                    color: const Color(0xFFF9F9F9),
                  ),
                  const BuildStudy(),
                  Container(
                    height: 2,
                    color: const Color(0xFFF9F9F9),
                  ),
                ])
            )
          ];
        },
        body: ListView.builder(
      itemCount: 50,
      itemBuilder: (BuildContext context, int index) {
        return ListTile(
          title: Text('Item $index'),
        );
      },
    ),
    );
  }
}
