part of book_detail;

class BookDetailController extends GetxController with GetSingleTickerProviderStateMixin{

  final String bookId;
  BookDetailController(this.bookId);

  late TabController tabController;
  final PageController pageController = PageController(initialPage: 0);
  List <Widget>tabs = [
    const Tab(text: '目录',),
    const Tab(text: '简介',),
    const Tab(text: '本书信息',),
  ];

  // 目录
  List <ChapterModel> chapters = [];
  // 图书
  BookDetailModel bookDetails = BookDetailModel();


  @override
  void onInit() {
    tabController = TabController(length: tabs.length, vsync: this);
    super.onInit();
  }

  @override
  void onReady() {
    _getBookDetails();
    _getChapters();
    super.onReady();
  }

  @override
  void onClose() {
    tabController.dispose();
    pageController.dispose();
    super.onClose();
  }

  /// 获取目录信息
  void _getChapters() async {
    chapters = await LibraryAPI.chapters(bookId: bookId);
    update();
  }

  /// 获取图书详细信息
  void _getBookDetails() async {
    bookDetails = await LibraryAPI.details(bookId:bookId);
    update();
  }
  /// 收藏 与 取消收藏
  void love({
    required String bookId,
    required num isCollection
  }) async {
    if (isCollection == 0) {
      isCollection = 1;
    }
    else {
      isCollection = 0;
    }
    bool result = await CommonAPI.love(
        bookId: bookId, love: isCollection.toString());
    print('================================$result');
    if (result) {
      _getBookDetails();
    }
  }






}