part of credit_points;

class CreditPointsPage extends StatelessWidget {
  const CreditPointsPage({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        context.pop('111111');
        return false;
      },
      child: Scaffold(
        extendBodyBehindAppBar: true,
        appBar: AppBar(
          centerTitle: true,
          title: const Text('积分'),
          backgroundColor: Colors.transparent,
        ),
        body:Stack(
          children: [
            Image.asset(
                'assets/images/point_bg.png',
              fit: BoxFit.contain,
              width: double.infinity,
            ),
            SafeArea(
              top: true,
              child: Column(
                children: [
                  // 积分卡片
                  Container(
                    padding: EdgeInsets.symmetric(horizontal: 10.w),
                    child: Container(
                      padding: EdgeInsets.only(left: 17.w,top: 18.w,bottom: 24.w,right: 17.w),
                      decoration: BoxDecoration(
                          color: Colors.white.withOpacity(0.58),
                          borderRadius: BorderRadius.circular(8.w),
                        border: Border.all(width: 2.w,color: Colors.white)
                      ),
                      height: 175.w,
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text('可用积分',style: TextStyle(fontSize: 16.w,height: 1.4,fontWeight: Fonts.medium,color: Colours.c3),),
                              Gaps.vGaps13,
                              Text('999',style: TextStyle(fontSize: 25.w,height: 1.4,fontWeight: Fonts.medium,color: Colours.c3),),
                            ],
                          ),
                          Row(
                            children: [
                              Expanded(
                                child: Container(
                                  height: 0.5.w,
                                  color: Colours.cE7,
                                ),
                              ),
                              Gaps.hGaps15,
                              Text('积分支付不能超过每笔订单的20%',style: TextStyle(fontSize: 12.w,height: 1.4,color: Colours.c9),),
                              Gaps.hGaps15,
                              Expanded(
                                child: Container(
                                  height: 0.5.w,
                                  color: Colours.cE7,
                                ),
                              ),
                            ],
                          )
                        ],
                      ),
                    ),
                  ),
                  // 使用积分
                  Container(
                    // height: 105,
                    margin: EdgeInsets.symmetric(horizontal: 10.w),
                    padding: EdgeInsets.all(20.w),
                    decoration: BoxDecoration(
                        color: Colors.white,
                        boxShadow: [
                          BoxShadow(
                            color: Colours.cC7.withOpacity(0.5),
                            offset: Offset(3.w, 0.w),
                            blurRadius: 4.w,
                            spreadRadius: 0,
                          ),
                        ],
                        borderRadius: BorderRadius.circular(8.w)
                    ),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text('可用积分',style: TextStyle(fontSize: 16.w,height: 1.4,fontWeight: Fonts.medium,color: Colours.c3),),
                        Gaps.vGaps10,
                        Container(
                          height: 0.5.w,
                          color: Colours.cE7,
                          // color: Colors.red,
                        ),
                        Gaps.vGaps15,
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            RichText(text: TextSpan(
                                children: [
                                  TextSpan(text: '抵扣',style: TextStyle(color: Colours.c9,fontSize: 13.w,height: 1.4)),
                                  TextSpan(text: '￥9.90',style: TextStyle(color: AppTheme.primary,fontSize: 13.w,height: 1.4,fontWeight: Fonts.medium)),
                                  TextSpan(text: '使用9900积分',style: TextStyle(color: Colours.c9,fontSize: 13.w,height: 1.4)),
                                ]
                            )),
                            SizedBox(
                              width: 15.w,
                              height: 15.w,
                              child: Image.asset(
                                'assets/images/uncheck.png',
                              ),
                            )
                          ],
                        )
                      ],
                    ),
                  )
                ],
              ),
            ),
          ],
        )
      ),
    );
  }
}
