part of web;

class ReadPage extends StatefulWidget {
  const ReadPage({Key? key}) : super(key: key);

  @override
  State<ReadPage> createState() => _ReadPageState();
}

class _ReadPageState extends State<ReadPage> {
  final GlobalKey webViewKey = GlobalKey();
  InAppWebViewController? webViewController;
  late ContextMenu contextMenu;
  @override
  void initState() {
    super.initState();
  }
  @override
  Widget build(BuildContext context) {
    return GetBuilder<ReadController>(
      init: ReadController(),
      builder: (readController) => Scaffold(
        // appBar: AppBar(title:const Text('章节名称'),),
       body: Stack(
         children: [
           Container(
             height: 40,
             width: double.infinity,
             color: Colors.lightBlue,
           ),
           InAppWebView(
             initialUrlRequest: URLRequest(
               url: Uri.parse('http://192.168.11.39:5500/'),
             ),
             onWebViewCreated: (InAppWebViewController controller) {
               webViewController = controller;
             },
             // onLoadError: (InAppWebViewController controller, Uri url, int code ,String msg){
             //
             // },
             contextMenu: ContextMenu(
               menuItems: [
                 ContextMenuItem(title: '划线',androidId: 1,iosId: '1',action: (){
                   const snackBar = SnackBar(
                     content: Text("划线"),
                     duration: Duration(seconds: 1),
                   );
                   ScaffoldMessenger.of(context).showSnackBar(snackBar);
                 }),
                 ContextMenuItem(title: '提问',androidId: 2,iosId: '2',action: (){

                 }),
                 ContextMenuItem(title: '笔记',androidId: 3,iosId: '3',action: (){

                 }),

               ],
               onCreateContextMenu: (hitTestResult) async {
                 String selectedText = await webViewController?.getSelectedText() ?? "";
                 final snackBar = SnackBar(
                   content: Text(
                       "Selected text: '$selectedText', of type: ${hitTestResult.type.toString()}"),
                   duration: const Duration(seconds: 1),
                 );
                 ScaffoldMessenger.of(context).showSnackBar(snackBar);
               },
               // options: ContextMenuOptions(
               //   hideDefaultSystemContextMenuItems: true,
               // ),
               onContextMenuActionItemClicked: (ContextMenuItem menuItem) async {
                 final snackBar = SnackBar(
                   content: Text(
                       "Menu item with ID ${menuItem.iosId} and title '${menuItem.title}' clicked!"),
                   duration: const Duration(seconds: 1),
                 );
                 ScaffoldMessenger.of(context).showSnackBar(snackBar);

                 // switch (item.title){
                 //   case '划线':
                 //     Console.log('----------划线-----------');
                 //     break;
                 //   case '提问':
                 //     Console.log('----------提问-----------');
                 //     break;
                 //   case '笔记':
                 //     Console.log('----------笔记-----------');
                 //     break;
                 //
                 // }
               }

             ),
             onLoadStop: (controller, url) {
               controller.addJavaScriptHandler(handlerName: 'onTap', callback: (args){
                 readController.setShow(readController.show);

               });
               controller.evaluateJavascript(source: '''
                  document.addEventListener('click', function() {
                    window.flutter_inappwebview.callHandler('onTap');
                  });
                ''');
             },
           ),
           AnimatedPositioned(
             duration: readController.controller.duration!,
             curve: Curves.easeInOut,
             top: readController.show ? 0 : -100, // 负值隐藏，0 显示
             left: 0,
             right: 0,
             height: 100,
             child: Container(
               color: Colors.limeAccent,
               alignment: Alignment.center,
               child: Text('top View'),
             ),
           ),
           AnimatedPositioned(
             duration: readController.controller.duration!,
             curve: Curves.easeInOut,
             bottom: readController.show ? 0 : -100, // 负值隐藏，0 显示
             left: 0,
             right: 0,
             height: 100,
             child: Container(
               color: Colors.limeAccent,
               alignment: Alignment.center,
               child: Text('Bottom View'),
             ),
           ),

         ],
       ),
      ),
    );

  }
}
