part of credit_points;

class CreditPointsPage extends StatelessWidget {
  const CreditPointsPage({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        context.pop('111111');
        return false;
      },
      child: Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('积分'),
        ),
        body: Column(
          children: [
            // 积分卡片
            Container(
              color: AppTheme.primary.withOpacity(0.02),
              padding: const EdgeInsets.all(10),
              child: Container(
                padding: const EdgeInsets.only(left: 17,top: 18,bottom: 24,right: 17),
                decoration: BoxDecoration(
                    color: Colors.white,
                    boxShadow: [
                      BoxShadow(
                        color: Colours.cC7.withOpacity(0.5),
                        offset: const Offset(0, 3),
                        blurRadius: 4,
                        spreadRadius: 0,
                      ),
                    ],
                    borderRadius: BorderRadius.circular(8)
                ),
                height: 175,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                     Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text('可用积分',style: TextStyle(fontSize: 16.w,height: 1.4,fontWeight: Fonts.medium,color: Colours.c3),),
                        Gaps.vGaps13,
                        Text('999',style: TextStyle(fontSize: 25.w,height: 1.4,fontWeight: Fonts.medium,color: Colours.c3),),
                      ],
                    ),
                    Row(
                      children: [
                        Expanded(
                          child: Container(
                            height: 0.5,
                            color: Colours.cE7,
                          ),
                        ),
                        Gaps.hGaps15,
                        const Text('积分支付不能超过每笔订单的20%',style: TextStyle(fontSize: 12,height: 1.4,color: Colours.c9),),
                        Gaps.hGaps15,
                        Expanded(
                          child: Container(
                            height: 0.5,
                            color: Colours.cE7,
                          ),
                        ),
                      ],
                    )
                  ],
                ),
              ),
            ),
            // 使用积分
            Container(
              // height: 105,
              padding: const EdgeInsets.all(20),
              decoration: BoxDecoration(
                  color: Colors.white,
                  boxShadow: [
                    BoxShadow(
                      color: Colours.cC7.withOpacity(0.5),
                      offset: const Offset(0, 3),
                      blurRadius: 4,
                      spreadRadius: 0,
                    ),
                  ],
                  borderRadius: BorderRadius.circular(8)
              ),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  const Text('可用积分',style: TextStyle(fontSize: 16,height: 1.4,fontWeight: Fonts.medium,color: Colours.c3),),
                  Gaps.vGaps10,
                  Container(
                    height: 0.5,
                    color: Colours.cE7,
                    // color: Colors.red,
                  ),
                  Gaps.vGaps15,
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      RichText(text: const TextSpan(
                        children: [
                          TextSpan(text: '抵扣',style: TextStyle(color: Colours.c9,fontSize: 13,height: 1.4)),
                          TextSpan(text: '￥9.90',style: TextStyle(color: AppTheme.primary,fontSize: 13,height: 1.4,fontWeight: Fonts.medium)),
                          TextSpan(text: '使用9900积分',style: TextStyle(color: Colours.c9,fontSize: 13,height: 1.4)),
                        ]
                      )),
                      SizedBox(
                        width: 15,
                        height: 15,
                        child: Image.asset(
                          'assets/images/uncheck.png',
                        ),
                      )
                    ],
                  )
                ],
              ),
            )
          ],
        ),
      ),
    );
  }
}
