part of user_discuss_des;

class UserDiscussDesPage extends StatefulWidget {
  final CourseModel model;
  const UserDiscussDesPage({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  State<UserDiscussDesPage> createState() => _UserDiscussDesPageState();
}

class _UserDiscussDesPageState extends State<UserDiscussDesPage> {

  List<Tab> tabs = [
    const Tab(text: '全部',),
    const Tab(text: '发起',),
    const Tab(text: '参与',),
  ];

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('讨论详情'),
        ),
        body: DefaultTabController(
            length: tabs.length,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                BuildItem(model: widget.model),
                ClipRRect(
                  borderRadius:const BorderRadius.only(topLeft: Radius.circular(5),topRight: Radius.circular(5)),
                  child: Container(
                    width: double.infinity,
                    color: Colors.white,
                    height: 35,
                    child: TabBar(
                        indicator: UnderlineTabIndicator(
                          borderRadius: BorderRadius.circular(0.75),
                          borderSide: const BorderSide(width: 1.5,color: AppTheme.primary),
                          insets: const EdgeInsets.symmetric(horizontal: 22), // 设置标签下面指示器的水平内边距
                        ),
                        labelPadding: const EdgeInsets.symmetric(horizontal: 20),
                        indicatorSize: TabBarIndicatorSize.label,
                        indicatorColor: AppTheme.primary,
                        indicatorWeight: 1.5,
                        labelStyle: const TextStyle(color: AppTheme.primary,fontSize: 15,height: 1.5,fontWeight: Fonts.medium),
                        unselectedLabelColor: Colours.c9,
                        unselectedLabelStyle: const TextStyle(color: Colours.c9,fontSize: 15,height: 1.5),
                        isScrollable: true,
                        tabs: tabs
                    ),
                  ),
                ),
                Expanded(
                  child: TabBarView(
                      children: List.generate(tabs.length, (index){
                        return BuildListPage(tag:'$index',model:widget.model);
                      })
                  ),
                )
              ],
            )
        ),
      );
  }
}
