part of user_set;

class UserSetPage extends StatefulWidget {
  const UserSetPage({Key? key}) : super(key: key);

  @override
  State<UserSetPage> createState() => _UserSetPageState();
}

class _UserSetPageState extends State<UserSetPage> {
  late UModel _getModel;
  String url =
      "https://imtt.dd.qq.com/16891/apk/FA48766BA12A41A1D619CB4B152889C6.apk?fsname=com.estrongs.android.pop_4.2.3.3_10089.apk&csr=1bbd";
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        centerTitle: true,
        title: const Text('设置'),
      ),
      body: Column(
        children: [
          Container(
            margin: const EdgeInsets.symmetric(vertical: 10,horizontal: 10),
            padding: const EdgeInsets.only(right: 10),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8),
              color: Colors.white,
              boxShadow: [
                BoxShadow(
                  color: const Color(0xFFC7C7C7).withOpacity(0.5),
                  offset: const Offset(3, 0),
                  blurRadius: 10.w,
                  spreadRadius: 0.w,
                ),
              ],
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                GestureDetector(
                  onTap: () async{
                    clearCache();
                  },
                  child: Container(
                    color: Colors.white,
                    margin: const EdgeInsets.only(left: 15),
                    height:45,
                    alignment: Alignment.centerLeft,
                    child: const Text('清除缓存',style: TextStyle(fontSize: 14,color: Colours.c3)),
                  ),
                ),
                Container(
                  margin: const EdgeInsets.only(left: 10),
                  height: 0.5,
                  color:Colours.cF0,
                ),
                GestureDetector(
                  onTap: () async{
                    _checkUpdates();
                  },
                  child: Container(
                    color: Colors.white,
                    margin: const EdgeInsets.only(left: 15),
                    height:45,
                    alignment: Alignment.centerLeft,
                    child: const Text('查看更新 >',style: TextStyle(fontSize: 14,color: Colours.c3)),
                  ),
                ),
                Container(
                  margin: const EdgeInsets.symmetric(horizontal: 10),
                  height: 0.5,
                  color:Colours.cF0,
                ),
                GestureDetector(
                  onTap: (){
                    context.pushNamed(Routes.version);
                  },
                  child: Container(
                    color: Colors.white,
                    margin: const EdgeInsets.only(left: 15),
                    height:45,
                    alignment: Alignment.centerLeft,
                    child: const Text('版本介绍 >',style: TextStyle(fontSize: 14,color: Colours.c3)),
                  ),
                )
              ],
            ),
          ),
          GestureDetector(
            onTap: () async{
              final result = await AccountAPI.logout();
              if (result){
                // Toast.show('退出成功');
                CustomToast.loading();
                await UserStore.to.logout();
                CustomToast.dismiss();
                if(context.mounted){
                  context.goNamed(Routes.splash);
                }
              }
            },
            child: Container(
              height: 42,
              width: double.infinity,
              alignment: Alignment.center,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(8),
                color: Colors.white,
                boxShadow: [
                  BoxShadow(
                    color: const Color(0xFFC7C7C7).withOpacity(0.5),
                    offset: const Offset(3, 0),
                    blurRadius: 10.w,
                    spreadRadius: 0.w,
                  ),
                ],
              ),
              margin: EdgeInsets.symmetric(horizontal: AppTheme.margin),
              child: const Text('退出登录',style: TextStyle(fontSize: 14,color: Colours.c3),),
            ),
          )
        ],
      ),
    );
  }

  void clearCache() {
    ClearCache().clearApplicationCache();
    Toast.show('清除完成');
  }
  void _checkUpdates() async {
    UModel model = await MineAPI.update();
    _getModel = model;
    final packageInfo = await PackageInfo.fromPlatform();
    int getVersion = int.parse(model.version!.replaceAll('.', ''));
    int localVersion = int.parse(packageInfo.version.replaceAll('.', ''));
    if (localVersion < getVersion){
      _showUpdateDialog(false);
    }

  }

  ///Flutter侧处理升级对话框
  ///[forcedUpgrade] 是否强制升级
  _showUpdateDialog(bool forcedUpgrade) {
    showDialog(
      context: context,
      barrierDismissible: !forcedUpgrade,
      builder: (BuildContext context) {
        return WillPopScope(
          onWillPop: () => Future.value(!forcedUpgrade),
          child: AlertDialog(
            shape: RoundedRectangleBorder(
              borderRadius: BorderRadius.circular(8.0),
            ),
            title: const Text('发现新版本',style: TextStyle(fontSize: 16,fontWeight: Fonts.medium,color: Colours.c3),),
            content:  Text(_getModel.remarks??'',style: const TextStyle(fontSize: 13,fontWeight: Fonts.medium,color: Colours.c3),),
            actions: <Widget>[
              if (!forcedUpgrade)
                TextButton(
                  child: const Text('取消',style: TextStyle(color: Colours.c3),),
                  onPressed: () => Navigator.of(context).pop(),
                ),
              TextButton(
                child: const Text('升级'),
                onPressed: () {
                  _appUpdate();
                  if (!forcedUpgrade) {
                    Navigator.of(context).pop();
                  }
                },
              ),
            ],
          ),
        );
      },
    );
  }
  /// TODO: 苹果市场app地址
  _appUpdate() {
    UpdateModel model = UpdateModel(
      _getModel.url!,
      "zijing.apk",
      "ic_launcher",
      'https://itunes.apple.com/cn/app/抖音/id1142110895',
    );
    AzhonAppUpdate.update(model).then((value) => debugPrint('$value'));
  }
}
