part of web;

class ReadPage extends StatefulWidget {
  final String bookId;
  final String chapterId;
  final String chapterName;
  final String noteId;
  final BookDetailModel bookDetailModel;
  const ReadPage({
    Key? key,
    required this.bookId,
    required this.chapterId,
    required this.chapterName,
    required this.bookDetailModel,
    required this.noteId
  }) : super(key: key);

  @override
  State<ReadPage> createState() => _ReadPageState();
}

class _ReadPageState extends State<ReadPage> {

  @override
  void initState() {
    super.initState();
  }
  @override
  Widget build(BuildContext context) {
    return GetBuilder(
        init: ReadController(bookId: widget.bookId, chapterId: widget.chapterId,chapterName: widget.chapterName,bookDetailModel: widget.bookDetailModel,noteId: widget.noteId),
        builder: (readController) => WillPopScope(
          onWillPop: () async {
            PopBackModel backModel = PopBackModel(chapterId: readController.chapterId,back: true,chapterName: readController.chapterId);
            context.pop(backModel);
            CustomToast.dismiss();
            return false;
          },
          child:Scaffold(
              appBar: CustomAppBar(
                titleSpacing: 0,
                title: Align(
                  alignment: Alignment.centerLeft,
                  child: Text(readController.chapterName),
                ),
                centerTitle: false,
                actions: [
                  GestureDetector(
                      onTap: () {
                        readController.getBookDown();
                      },
                      child:  Text(
                        readController.existDownFile == true?'':'离线阅读',
                        style: TextStyle(
                            fontSize: 14.w, color: Colours.c3),
                      ))
                ],
              ),
              resizeToAvoidBottomInset: false,
              floatingActionButton: readController.show&& !readController.toolModel.selected?GestureDetector(
                onTap: (){
                  readController.setShowChat(true);
                  readController.setChatType(0);
                },
                child: Image.asset('assets/images/chat.png'),
              ):null,
              // floatingActionButtonAnimator: const NoAnimationFabAnimator(),
              floatingActionButtonLocation:MyFloatingActionButtonLocation(),
              body: Container(
                color: Colors.white,
                child: Stack(
                  children: [
                    InAppWebView(
                      initialFile: readController.existDownFile && !readController.netStatus?'assets/html/read_unline.html':'assets/html/read.html',
                      // initialUrlRequest:URLRequest(
                      //     url:WebUri.uri(Uri.parse(kReadTestUnderLineBook))
                      //     // url: readController.existDownFile && !readController.netStatus? WebUri.uri(Uri.parse(kReadTestUnderLineBook)): WebUri.uri(Uri.parse(kReadBook))
                      // ),
                      initialSettings:InAppWebViewSettings(
                        clearCache:true,
                        // http的请求也不做限制
                        mixedContentMode:MixedContentMode.MIXED_CONTENT_ALWAYS_ALLOW
                      ),
                      contextMenu: ContextMenu(
                        settings: ContextMenuSettings(
                          hideDefaultSystemContextMenuItems: true,
                        )
                      ),
                      onWebViewCreated: (InAppWebViewController controller){
                        // CustomToast.loading();
                        readController.webViewController = controller;
                      },
                      onConsoleMessage: (controller, consoleMessage) {
                        // 接收从 WebView 发送的消息
                        Console.log("Received message from WebView-----------------------------: ${consoleMessage.message}");
                      },
                      onLoadStop: (controller, url) {
                        if(readController.existDownFile && !readController.netStatus){
                          Console.log('-----------------加载离线数据---------------');
                          readController.getOffLineInfo();
                        }
                        else {
                          String str = '$kServerUrl,${readController.bookId},${readController.chapterId},${UserStore.to.token},${readController.noteId},${readController.sModel.bookId =='0'?'':readController.sModel.combinedContent}';
                          Console.log('-----------------加载在线数据---------------$str');
                          controller.evaluateJavascript(source: 'callbackInFlutterComponent("$str");');
                        }

                        // 添加单击事件
                        controller.evaluateJavascript(source: '''
                           document.addEventListener('click', function() {
                             window.flutter_inappwebview.callHandler('onTap');
                           });
                         ''');
                        // 监听js单击回调
                        controller.addJavaScriptHandler(handlerName: 'onTap', callback: (args){
                          readController.setShow(readController.show);

                        });

                        // 监听笔记回调
                        controller.addJavaScriptHandler(handlerName: 'noteCallBack', callback: (args){
                          Console.log('监听笔记回调------------------------------------------------$args');
                          readController.noteTitle = args.first;
                          readController.setShowChat(true);
                          readController.setChatType(1);
                          // readController.titleInput.text = args.toString();
                        });

                        // 监听百科回调
                        controller.addJavaScriptHandler(handlerName: 'baikeCallBack', callback: (args){
                          Console.log('监听百科回调------------------------------------------------$args');
                          context.pushNamed(Routes.baiKe,queryParameters: {'keyword':args.first});
                        });

                        // 监听字典回调
                        controller.addJavaScriptHandler(handlerName: 'dictCallBack', callback: (args){
                          Console.log('监听字典回调------------------------------------------------$args');
                          context.pushNamed(Routes.baiDict,queryParameters: {'keyword':args.first});
                        });

                        // 监听朗读回调
                        controller.addJavaScriptHandler(handlerName: 'readCallBack', callback: (args){
                          Console.log('监听朗读回调------------------------------------------------$args');
                          readController.speak(args.first.toString());
                        });

                        // 监听讨论回调
                        controller.addJavaScriptHandler(handlerName: 'discussCallBack', callback: (args){
                          Console.log('监听讨论回调------------------------------------------------$args');
                          readController.setShowChat(true);
                          readController.setChatType(0);
                          readController.noteTitle = args.first.toString();
                        });

                        // 答题和答题结果页回调
                        controller.addJavaScriptHandler(handlerName: 'answerResultCallBack', callback: (args){
                          Console.log('监听答题回调------------------------------------------------$args');

                          String chapterId = args.first[0].toString();
                          String position = args.first[1].toString();
                          //  0：未答题 1：答题结果
                          String type = args.first[2].toString();
                          // 测评标题
                          String title = args.first[3].toString();
                          String url = '';
                          // 未答题
                          if(type == '0'){
                            url = kAnswer;
                          }
                          else {
                            url = kAnswerResult;
                          }
                          Map<String,String> params = {
                            'chapter_id':chapterId,
                            'position':position,
                            'url':url,
                            'book_id':readController.bookId,
                            'token':UserStore.to.token,
                            'title':title
                          };
                          Console.log('监听答题回调---------------给页面传参---------------------------------$params');
                          // 跳转知识测评界面
                          context.pushNamed(Routes.answer,queryParameters: params);

                        });

                        // 监听 上一节 下一节
                        controller.addJavaScriptHandler(handlerName: 'loadChapterCallBack', callback: (args){
                          String chapterId = args.first[0].toString();
                          String chapterName = args.first[1].toString();
                          ChapterModel  chapterModel = ChapterModel(id: int.parse(chapterId), name: chapterName);
                          // readController.setChapterInfo(id: chapterId, name: chapterName ?? '');
                          readController.selectChapter(chapterModel);
                          if(readController.existDownFile && !readController.netStatus){
                            readController.getOffLineInfo();
                          }
                          Console.log('监听 上一节 下一节------------------------------------------------$args');
                        });

                        // // 监听 双击回调
                        // controller.addJavaScriptHandler(handlerName: 'dbClickCallBack', callback: (args){
                        //   readController.setShow(readController.show);
                        // });

                        // 阅读页内容中的 外部链接
                        controller.addJavaScriptHandler(handlerName: 'openLinkCallback', callback: (args){
                          Console.log('监听外部链接------------------------------------------------$args');
                          context.pushNamed(Routes.link,queryParameters: {'url': args.first.toString()});
                        });

                        // 画廊 扩展于都
                        controller.addJavaScriptHandler(handlerName: 'readInfoCallback', callback: (args){
                          String position = args.first[0].toString();
                          String type = args.first[1].toString();
                          String title = args.first[2].toString();
                          Map<String,String> params = {
                            'chapter_id':readController.chapterId,
                            'position':position,
                            'book_id':readController.bookId,
                            'token':UserStore.to.token,
                            'title':title,
                            'base_url':kServerUrl,
                            'type':type
                          };
                          Console.log('监听画廊 扩展于都---------------给页面传参---------------------------------$params');
                          context.pushNamed(Routes.readInfo,queryParameters: params);
                        });

                        // 购买回调
                        controller.addJavaScriptHandler(handlerName: 'payCallback', callback: (args){
                          List<CourseModel> buy = [];
                          CourseModel model= CourseModel(
                              bookId: readController.bookDetailModel.bookId,
                              price: readController.bookDetailModel.price,
                              vipPrice: readController.bookDetailModel.vipPrice,
                              img: readController.bookDetailModel.img,
                              bookName: readController.bookDetailModel.bookName,
                              cartId: 0,
                              status: 1,
                              selected: true
                          );
                          buy.add(model);

                          context.pushNamed(Routes.bookPay,extra: buy).then((value){
                            controller.reload();
                          });
                        });

                        // 图片预览
                        controller.addJavaScriptHandler(handlerName: 'scaleImageCallback', callback: (args){
                          String url = args.first[0].toString();
                          String title = args.first[1].toString();
                          Map<String,String> params = {
                            'url':url,
                            'title':title,
                          };
                          Console.log('监听图片预览---------------给页面传参---------------------------------$params');
                          context.pushNamed(Routes.scaleImage,queryParameters: params);
                        });

                        // 前端 token过期回调
                        controller.addJavaScriptHandler(handlerName: 'refreshTokenCallback', callback: (args) async {
                          Console.log('刷新token------------------------');
                           final result = await readController.refreshToken();
                           Map<String, dynamic> param = {
                             'token': result,
                           };
                           String jsonStr = jsonEncode(param);
                          Console.log('刷新token------------------------$jsonStr');
                           controller.evaluateJavascript(source: 'refreshTokenSuccess($jsonStr)');
                        });
                        controller.addJavaScriptHandler(handlerName: 'showLoadingCallback', callback: (args) async {
                          CustomToast.loading();
                        });
                        controller.addJavaScriptHandler(handlerName: 'dismissLoadingCallback', callback: (args) async {
                          CustomToast.dismiss();
                        });

                        /// 离线需要参数
                        // 添加高亮划线笔记
                        controller.addJavaScriptHandler(handlerName: 'offlineAddNoteCallBack', callback: (args){
                          Console.log('添加笔记回调------------------------------------------${args[0]}');
                          Map<String,dynamic> data = args[0];
                          readController.addLocalNote(data);
                        });

                        // 删除高亮划线笔记
                        controller.addJavaScriptHandler(handlerName: 'offlineDelNoteCallBack', callback: (args){
                          Console.log('删除笔记回调------------------------------------------${args[0]}');
                          Map<String,dynamic> data = args[0];
                          int notesId = data['notes_id'];
                          int id = 0;
                          if(data.keys.contains('id')){
                            id = data['id'];
                          }
                          readController.delLocalNote(noteId: notesId,id: id);
                        });

                        // 更新高亮划线笔记
                        controller.addJavaScriptHandler(handlerName: 'offlineUpdateNoteCallBack', callback: (args){
                          Console.log('更新笔记回调------------------------------------------${args[0]}');
                          // int id = 0;
                          // Map<String, dynamic> data = {};
                          Map<String,dynamic> data = args[0];
                          int notesId = data['notes_id'];
                          int id = 0;
                          if(data.keys.contains('id')){
                            id = data['id'];
                          }
                          readController.updateLocalNote(notesId: notesId,id:id, data: data);
                        });
                      },
                    ),
                    Positioned(
                        left: 0,
                        right: 0,
                        top: 0,
                        bottom: 69,
                        child: _showContent(readController,readController.toolModel)
                    ),
                    /// 底部工具栏布局
                    Visibility(
                        visible: readController.show,
                        child:Positioned(
                          left: 0,
                          right: 0,
                          bottom: 0,
                          child: SafeArea(
                            bottom: false,
                            child: Container(
                                height: 69,
                                color: Colors.limeAccent,
                                alignment: Alignment.center,
                                child: _createToolBar(readController)
                            ),
                          ),
                        )
                    ),
                    /// 悬浮按钮点击发起话题布局
                    Visibility(
                      visible: readController.showChat,
                      child: Positioned(
                          left: 0,
                          right: 0,
                          top: 0,
                          bottom:0,
                          child: GestureDetector(
                            onTap: (){
                              readController.setShowChat(false);
                              readController.clearAllDiscussInput();

                            },
                            child: Container(
                              color: const Color(0xFF000000).withOpacity(0.5),
                              child: SingleChildScrollView(
                                reverse: true,
                                child: Container(
                                    color: Colors.white,
                                    padding: EdgeInsets.only(bottom: MediaQuery.of(context).viewInsets.bottom),
                                    // alignment:Alignment.bottomCenter,
                                    child: GestureDetector(
                                        behavior: HitTestBehavior.opaque,
                                        onTap: (){},
                                        child: ReadInputDiscuss(controller: readController,)
                                    )
                                ),
                              ),
                            ),
                          )
                      ),
                    ),
                  ],
                ),
              ),
            ),
          ),
        );

  }

  // 目录 笔记 讨论 工具栏
  Widget _createToolBar(ReadController controller){
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceAround,
      children: controller.tools.map((model){
        return Expanded(
          child: GestureDetector(
            onTap: (){
              controller.chooseTool(model);
            },
            child: Container(
              color: Colors.white,
              padding: EdgeInsets.only(bottom: 15.w),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                mainAxisSize: MainAxisSize.max,
                children: [
                  SizedBox(
                    width: 25,
                    height: 25,
                    child: Image.asset(model.selected?model.activeIcon:model.icon,fit: BoxFit.cover,)
                  ),
                  SizedBox(height: 2.5.w,),
                  model.selected?Text(model.name,style: TextStyle(fontSize: 12.w,height: 1.4,fontWeight: Fonts.boldSemi,color: AppTheme.primary),)
                      :Text(model.name,style: TextStyle(fontSize: 12.w,height: 1.4,fontWeight: Fonts.medium,color: Colours.c6))
                ],
              ),
            ),
          ),
        );
      }).toList()
    );
  }

  Widget detail(ReadController controller,ToolModel model){
    if(model.tag == 0){
      return ReadCategoryPage(controller: controller,
        // 点 x 事件
        onTap: (){
          controller.chooseTool(model);
        },
        // 点 搜索全部 列表 某一项 事件
        onTapSearchItem: (SearchAllModel sModel){
          controller.chooseTool(model);
          // 加载阅读界面 参数：chapter_id  text
          controller.sModel = sModel;
          controller.selectChapter(ChapterModel(id: sModel.chapterId,name: sModel.chapterName));
          controller.webViewController.reload();
        },
        onTapChapter: (ChapterModel chapterModel){
          // 配置选择的章节
          controller.selectChapter(chapterModel);
          // 取消选中 tool
          controller.chooseTool(model);
          // 选择了新的章节 刷新 webview
          controller.webViewController.reload();
          // controller.setCurrentReadChapterId();
        },
      );
    }
    else if(model.tag == 1){
      return ReadNotePage(
        // 点 x 事件
        onTap: (){
          controller.chooseTool(model);
        },
        // 点 搜索全部 列表 某一项 事件
        onTapSearchItem: (SearchAllModel sModel){
          controller.chooseTool(model);
          // 重新加载阅读界面 参数：chapter_id  text
          controller.sModel = sModel;
          controller.selectChapter(ChapterModel(id: sModel.chapterId,name: sModel.chapterName));
          controller.webViewController.reload();
        },
        // 删除笔记后 重新刷新web页
        delTapCallBack: (){
          controller.webViewController.reload();
        },
        bookDetailModel: controller.bookDetailModel,
        chapterId: controller.chapterId,
      );
    }
    else if(model.tag == 2){
      return ReadDiscussPage(
        // 点 x 事件
        onTap: (){
          controller.chooseTool(model);
        },
        // 点 搜索全部 列表 某一项 事件
        onTapSearchItem: (SearchAllModel sModel){
          controller.chooseTool(model);
          controller.sModel = sModel;
          // 重新加载阅读界面 参数：chapter_id  text
          controller.selectChapter(ChapterModel(id: sModel.chapterId,name: sModel.chapterName));
          controller.webViewController.reload();
        },
        bookDetailModel: controller.bookDetailModel,
        chapterId:controller.chapterId,
      );
    }
    return const SizedBox();
  }
  // 目录、评论、笔记 背景
  Widget _showContent(ReadController controller,ToolModel model) {
    if (controller.show){
      if(model.selected){
        return GestureDetector(
          onTap: (){
            controller.chooseTool(model);
          },
          child: Container(
            color: const Color(0xFF000000).withOpacity(0.5),
            padding: EdgeInsets.only(top: MediaQuery.of(context).size.height * 0.2),
            child: ClipRRect(
              borderRadius: BorderRadius.only(topRight: Radius.circular(8.w),topLeft: Radius.circular(8.w)),
              child: Container(
                  color: Colors.white,
                  child: GestureDetector(
                    behavior: HitTestBehavior.opaque,
                    onTap: (){},
                    child: detail(controller, model),
                  )
              ),
            ),
            // child: ReadCategoryPage(),
          ),
        );
      }
      else{
        return const SizedBox();
      }
    }
    return const SizedBox();
  }
}


// 定制 悬浮按钮位置
class MyFloatingActionButtonLocation extends FloatingActionButtonLocation {
  @override
  Offset getOffset(ScaffoldPrelayoutGeometry scaffoldGeometry) {
    // You can customize the position of the FloatingActionButton here
    return Offset(scaffoldGeometry.scaffoldSize.width - 15.0.w - 45.w, scaffoldGeometry.scaffoldSize.height - 118.w-49.w);
  }

  @override
  String toString() => 'MyFloatingActionButtonLocation';
}



