part of search;

class BuildHistory extends StatefulWidget {
  final SearchController controller;
  const BuildHistory({
    Key? key,
    required this.controller,
  }) : super(key: key);

  @override
  State<BuildHistory> createState() => _BuildHistoryState();
}

class _BuildHistoryState extends State<BuildHistory> {

  @override
  Widget build(BuildContext context) {
    return  Container(
        margin: EdgeInsets.only(left: 13.w,top: 18.w),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Text('搜索历史',style: TextStyle(fontSize: 14.w,height: 1.5,color: Colours.c3,fontWeight: Fonts.boldSemi),),
                GestureDetector(
                  onTap: (){
                     widget.controller.clear();
                  },
                  child: Container(
                    padding: EdgeInsets.all(10.w),
                    // width: 10,
                    // height: 10,
                    // color: Colors.cyan,
                    child: Image.asset(
                      'assets/images/del.png',
                    ),
                  ),
                )
              ],
            ),
            Wrap(
              spacing: 10.w,
              runSpacing: 10.w,
              alignment: WrapAlignment.start,
              runAlignment: WrapAlignment.start,
              children: _buildItem(widget.controller.records),
            ),
          ],
        ),
      );
  }

  List <Widget> _buildItem(List<String> searchList){
    if (searchList == null || searchList.isEmpty){
      List<Widget> list = [
        const SizedBox(
          width: 0,
          height: 0,
        )
      ];
      return list;
    }else {
      return searchList.map((e){
        return GestureDetector(
          onTap: () {
            // showHistory = false;
            widget.controller.searchController.text =e;
            widget.controller.showHistory = false;
            widget.controller.search();
            Console.log('点击了-$e');
          },
          child: Container(
            height: 27,
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(13.5),
              color: Colours.cF4
            ),
            child: Padding(
              padding: const EdgeInsets.symmetric(horizontal:15,vertical: 3),
              child: Text(e,style: const TextStyle(fontSize: 13,height: 1.5,color: Colours.c3),textAlign: TextAlign.center,),
            ),
          ),
        );
      }).toList();
    }
  }
}
