part of store;

class UserStore extends GetxController{
  // 获取 UserStore 实例
  static UserStore get to => Get.find();
  
  // 是否登录
  bool _isLogin = false;

  String _token = '';
  String get token => _token;


  String _accessToken = '';
  String get accessToken => _accessToken;


  bool get isLogin=> _isLogin;
  bool get hasToken => _token.isNotEmpty;

  UserModel _info = UserModel();
  UserModel get info => _info;

  // 是否需要登录
  final ValueNotifier<bool> _needLogin = ValueNotifier<bool>(false);
  ValueNotifier<bool> get needLogin => _needLogin;

  
  
  @override
  void onInit() {
    super.onInit();
    _token = StorageService.to.getString(kLocalToken);
  }

  Future<void>login(UserModel value) async{
    _token  = value.token??'';
    _accessToken = value.accessToken??'';
    await StorageService.to.setString(kLocalToken,_token);
    await StorageService.to.setString(kLocalAccessToken, value.accessToken??'');
    await StorageService.to.setString(kLocalUserInfo, jsonEncode(value.toJson()));
    _needLogin.value = false;
    _info = value;
    _isLogin = true;
    update();
  }
  Future<void> setToken(String value) async {
    await StorageService.to.setString(kLocalToken, value);
    _token = value;
  }

  Future<void> setAccessToken(String value) async {
    await StorageService.to.setString(kLocalAccessToken, value);
    _accessToken = value;
  }

  Future<void> setInfo(UserModel value) async {
    await StorageService.to.setString(kLocalUserInfo, jsonEncode(value.toJson()));
    _needLogin.value = false;
    _info = value;
  }

  // 登出
  Future<void> logout() async {
    await StorageService.to.remove(kLocalToken);
    await StorageService.to.remove(kLocalAccessToken);
    await StorageService.to.remove(kLocalUserInfo);
    _token = '';
    _isLogin = false;
    _needLogin.value = true;
  }

  Future<void> profile() async {
    
    if (!hasToken) return;
    _isLogin = true;
    update();
  }

  
}