part of main;


class MainPage extends StatefulWidget {
  const MainPage({Key? key}) : super(key: key);

  @override
  State<MainPage> createState() => _MainPageState();
}

class _MainPageState extends State<MainPage> with WidgetsBindingObserver{

  @override
  void initState() {
    super.initState();
    WidgetsBinding.instance.addObserver(this);
  }


  @override
  void didChangePlatformBrightness() {
    super.didChangePlatformBrightness();
    AppTheme.setSystemStyle();
  }

  @override
  void dispose() {
    WidgetsBinding.instance.removeObserver(this);
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<MainController>(
        init: MainController(),
        builder: (controller) => Scaffold(
          body: PageView(
            physics: const NeverScrollableScrollPhysics(),
            controller: controller.pageController,
            onPageChanged: controller.onPageChanged,
            children: const [
              HomePage(),
              TestTTSPage(),
              HomePage(),
              HomePage(),
            ],
          ),
          bottomNavigationBar: GetBuilder<MainController>(
            id: 'navigation',
            builder: (controller) => BottomNavigationBar(
                currentIndex:controller.currentPage ,
                onTap: (page){
                  controller.pageController.jumpToPage(page);
                },
                items: const [
                    BottomNavigationBarItem(
                        icon: Icon(Ionicons.home_outline),
                        activeIcon:Icon(Ionicons.home),
                        label: '首页',
                    ),
                    BottomNavigationBarItem(
                      icon: Icon(Ionicons.apps_outline),
                      activeIcon:Icon(Ionicons.apps),
                      label: '图书馆',
                    ),
                    BottomNavigationBarItem(
                      icon: Icon(Ionicons.chatbubbles_outline),
                      activeIcon:Icon(Ionicons.chatbubbles),
                      label: '购物车',
                    ),
                    BottomNavigationBarItem(
                      icon: Icon(Ionicons.person_outline),
                      activeIcon:Icon(Ionicons.person),
                      label: '我的',
                    )
                ]
            ),
          ),
        )
    );
  }
}
